/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-test2.xml")
public class HostNameTest {
    private final ListAppender host;
    private final RollingFileAppender hostFile;

    public HostNameTest(@Named(value="HostTest") ListAppender list, @Named(value="HostFile") RollingFileAppender rolling) {
        this.host = list.clear();
        this.hostFile = rolling;
    }

    @Test
    public void testHostname(LoggerContext context) {
        Logger testLogger = context.getLogger("org.apache.logging.log4j.hosttest");
        testLogger.debug("Hello, {}", (Object)"World");
        List<String> msgs = this.host.getMessages();
        MatcherAssert.assertThat(msgs, (Matcher)Matchers.hasSize((int)1));
        String expected = NetUtils.getLocalHostname() + Strings.LINE_SEPARATOR;
        MatcherAssert.assertThat((Object)msgs.get(0), (Matcher)Matchers.endsWith((String)expected));
        Assertions.assertNotNull((Object)this.hostFile.getFileName(), (String)"No Host FileAppender file name");
        expected = "target/" + NetUtils.getLocalHostname() + ".log";
        String name = this.hostFile.getFileName();
        Assertions.assertEquals((Object)name, (Object)expected, (String)("Incorrect HostFile FileAppender file name - expected " + expected + " actual - " + name));
        name = this.hostFile.getFilePattern();
        Assertions.assertNotNull((Object)name, (String)"No file pattern");
        expected = "target/" + NetUtils.getLocalHostname() + "-%d{MM-dd-yyyy}-%i.log";
        Assertions.assertEquals((Object)name, (Object)expected, (String)("Incorrect HostFile FileAppender file pattern - expected " + expected + " actual - " + name));
    }
}

