/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.junit.LoggerContextSource;
import org.apache.logging.log4j.junit.Named;
import org.apache.logging.log4j.test.ExtendedLevels;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@LoggerContextSource(value="log4j-customLevel.xml")
public class ExtendedLevelTest {
    private final ListAppender list1;
    private final ListAppender list2;

    public ExtendedLevelTest(@Named(value="List1") ListAppender list1, @Named(value="List2") ListAppender list2) {
        this.list1 = list1.clear();
        this.list2 = list2.clear();
    }

    @Test
    public void testLevelLogging(LoggerContext context) {
        Logger logger = context.getLogger("org.apache.logging.log4j.test1");
        logger.log(ExtendedLevels.DETAIL, "Detail message");
        logger.log(Level.DEBUG, "Debug message");
        List<LogEvent> events = this.list1.getEvents();
        Assertions.assertNotNull(events, (String)"No events");
        MatcherAssert.assertThat(events, (Matcher)Matchers.hasSize((int)1));
        LogEvent event = events.get(0);
        Assertions.assertEquals((Object)"DETAIL", (Object)event.getLevel().name(), (String)("Expected level DETAIL, got" + event.getLevel()));
        logger = context.getLogger("org.apache.logging.log4j.test2");
        logger.log(ExtendedLevels.NOTE, "Note message");
        logger.log(Level.INFO, "Info message");
        events = this.list2.getEvents();
        Assertions.assertNotNull(events, (String)"No events");
        MatcherAssert.assertThat(events, (Matcher)Matchers.hasSize((int)1));
        event = events.get(0);
        Assertions.assertEquals((Object)"NOTE", (Object)event.getLevel().name(), (String)("Expected level NOTE, got" + event.getLevel()));
    }
}

