/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.pattern.DatePatternConverter;
import org.apache.logging.log4j.core.pattern.EndOfBatchPatternConverter;
import org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.LoggerFqcnPatternConverter;
import org.apache.logging.log4j.core.pattern.MapPatternConverter;
import org.apache.logging.log4j.core.pattern.NanoTimePatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.ThreadIdPatternConverter;
import org.apache.logging.log4j.core.pattern.ThreadNamePatternConverter;
import org.apache.logging.log4j.core.pattern.ThreadPriorityPatternConverter;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.SystemNanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PatternParserTest {
    static String OUTPUT_FILE = "output/PatternParser";
    static String WITNESS_FILE = "witness/PatternParser";
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    private static String msgPattern = "%m%n";
    private final String mdcMsgPattern1 = "%m : %X%n";
    private final String mdcMsgPattern2 = "%m : %X{key1}%n";
    private final String mdcMsgPattern3 = "%m : %X{key2}%n";
    private final String mdcMsgPattern4 = "%m : %X{key3}%n";
    private final String mdcMsgPattern5 = "%m : %X{key1},%X{key2},%X{key3}%n";
    private final String deeplyNestedPattern = "%notEmpty{ %maxLen{%X{var}}{3} }";
    private static String badPattern = "[%d{yyyyMMdd HH:mm:ss,SSS] %-5p [%c{10}] - %m%n";
    private static String customPattern = "[%d{yyyyMMdd HH:mm:ss,SSS}] %-5p [%-25.25c{1}:%-4L] - %m%n";
    private static String patternTruncateFromEnd = "%d; %-5p %5.-5c %m%n";
    private static String patternTruncateFromBeginning = "%d; %-5p %5.5c %m%n";
    private static String nestedPatternHighlight = "%highlight{%d{dd MMM yyyy HH:mm:ss,SSS}{GMT+0} [%t] %-5level: %msg%n%throwable}";
    private static final String KEY = "Converter";
    private PatternParser parser;

    @BeforeEach
    public void setup() {
        this.parser = new PatternParser(KEY);
    }

    private void validateConverter(List<PatternFormatter> formatter, int index, String name) {
        LogEventPatternConverter pc = formatter.get(index).getConverter();
        Assertions.assertEquals((Object)pc.getName(), (Object)name, (String)("Incorrect converter " + pc.getName() + " at index " + index + " expected " + name));
    }

    @Test
    public void defaultPattern() {
        List formatters = this.parser.parse(msgPattern);
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)formatters.size(), (int)2);
        this.validateConverter(formatters, 0, "Message");
        this.validateConverter(formatters, 1, "Line Sep");
    }

    @Test
    public void testCustomPattern() {
        List formatters = this.parser.parse(customPattern);
        Assertions.assertNotNull((Object)formatters);
        StringMap mdc = ContextDataFactory.createContextData();
        mdc.putValue("loginId", (Object)"Fred");
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("org.apache.logging.log4j.PatternParserTest").setMarker(MarkerManager.getMarker((String)"TEST")).setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world")).setContextData(mdc).setThreadName("Thread1").setSource(elements[0]).setTimeMillis(System.currentTimeMillis()).build();
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : formatters) {
            formatter.format((LogEvent)event, buf);
        }
        String str = buf.toString();
        String expected = "INFO  [PatternParserTest        :99  ] - Hello, world" + Strings.LINE_SEPARATOR;
        Assertions.assertTrue((boolean)str.endsWith(expected), (String)("Expected to end with: " + expected + ". Actual: " + str));
    }

    @Test
    public void testPatternTruncateFromBeginning() {
        List formatters = this.parser.parse(patternTruncateFromBeginning);
        Assertions.assertNotNull((Object)formatters);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("org.apache.logging.log4j.PatternParserTest").setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world")).setThreadName("Thread1").setTimeMillis(System.currentTimeMillis()).build();
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : formatters) {
            formatter.format((LogEvent)event, buf);
        }
        String str = buf.toString();
        String expected = "INFO  rTest Hello, world" + Strings.LINE_SEPARATOR;
        Assertions.assertTrue((boolean)str.endsWith(expected), (String)("Expected to end with: " + expected + ". Actual: " + str));
    }

    @Test
    public void testPatternTruncateFromEnd() {
        List formatters = this.parser.parse(patternTruncateFromEnd);
        Assertions.assertNotNull((Object)formatters);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("org.apache.logging.log4j.PatternParserTest").setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world")).setThreadName("Thread1").setTimeMillis(System.currentTimeMillis()).build();
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : formatters) {
            formatter.format((LogEvent)event, buf);
        }
        String str = buf.toString();
        String expected = "INFO  org.a Hello, world" + Strings.LINE_SEPARATOR;
        Assertions.assertTrue((boolean)str.endsWith(expected), (String)("Expected to end with: " + expected + ". Actual: " + str));
    }

    @Test
    public void testBadPattern() {
        Calendar cal = Calendar.getInstance();
        cal.set(2001, 1, 3, 4, 5, 6);
        cal.set(14, 789);
        long timestamp = cal.getTimeInMillis();
        List formatters = this.parser.parse(badPattern);
        Assertions.assertNotNull((Object)formatters);
        Throwable t = new Throwable();
        StackTraceElement[] elements = t.getStackTrace();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("a.b.c").setLoggerFqcn(Logger.class.getName()).setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world")).setThreadName("Thread1").setSource(elements[0]).setTimeMillis(timestamp).build();
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : formatters) {
            formatter.format((LogEvent)event, buf);
        }
        String str = buf.toString();
        String expected = "[2001-02-03 04:05:06,789] - Hello, world";
        Assertions.assertTrue((boolean)str.startsWith("[2001-02-03 04:05:06,789] - Hello, world"), (String)("Expected to start with: [2001-02-03 04:05:06,789] - Hello, world. Actual: " + str));
    }

    @Test
    public void testNestedPatternHighlight() {
        this.testNestedPatternHighlight(Level.TRACE, "\u001b[30m");
        this.testNestedPatternHighlight(Level.DEBUG, "\u001b[36m");
        this.testNestedPatternHighlight(Level.INFO, "\u001b[32m");
        this.testNestedPatternHighlight(Level.WARN, "\u001b[33m");
        this.testNestedPatternHighlight(Level.ERROR, "\u001b[1;31m");
        this.testNestedPatternHighlight(Level.FATAL, "\u001b[1;31m");
    }

    private void testNestedPatternHighlight(Level level, String expectedStart) {
        List formatters = this.parser.parse(nestedPatternHighlight);
        Assertions.assertNotNull((Object)formatters);
        Throwable t = new Throwable();
        t.getStackTrace();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("org.apache.logging.log4j.PatternParserTest").setMarker(MarkerManager.getMarker((String)"TEST")).setLoggerFqcn(Logger.class.getName()).setLevel(level).setMessage((Message)new SimpleMessage("Hello, world")).setThreadName("Thread1").setSource(null).setTimeMillis(System.currentTimeMillis()).build();
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter formatter : formatters) {
            formatter.format((LogEvent)event, buf);
        }
        String str = buf.toString();
        String expectedEnd = String.format("] %-5s: Hello, world%s\u001b[m", level, Strings.LINE_SEPARATOR);
        Assertions.assertTrue((boolean)str.startsWith(expectedStart), (String)("Expected to start with: " + expectedStart + ". Actual: " + str));
        Assertions.assertTrue((boolean)str.endsWith(expectedEnd), (String)("Expected to end with: \"" + expectedEnd + "\". Actual: \"" + str));
    }

    @Test
    public void testNanoPatternShort() {
        this.testFirstConverter("%N", NanoTimePatternConverter.class);
    }

    @Test
    public void testNanoPatternLong() {
        this.testFirstConverter("%nano", NanoTimePatternConverter.class);
    }

    @Test
    public void testThreadNamePattern() {
        this.testThreadNamePattern("%thread");
    }

    @Test
    public void testThreadNameFullPattern() {
        this.testThreadNamePattern("%threadName");
    }

    @Test
    public void testThreadIdFullPattern() {
        this.testThreadIdPattern("%threadId");
    }

    @Test
    public void testThreadIdShortPattern1() {
        this.testThreadIdPattern("%tid");
    }

    @Test
    public void testThreadIdShortPattern2() {
        this.testThreadIdPattern("%T");
    }

    @Test
    public void testThreadPriorityShortPattern() {
        this.testThreadPriorityPattern("%tp");
    }

    @Test
    public void testThreadPriorityFullPattern() {
        this.testThreadPriorityPattern("%threadPriority");
    }

    @Test
    public void testLoggerFqcnPattern() {
        this.testFirstConverter("%fqcn", LoggerFqcnPatternConverter.class);
    }

    @Test
    public void testEndOfBatchPattern() {
        this.testFirstConverter("%endOfBatch", EndOfBatchPatternConverter.class);
    }

    private void testThreadIdPattern(String pattern) {
        this.testFirstConverter(pattern, ThreadIdPatternConverter.class);
    }

    private void testThreadNamePattern(String pattern) {
        this.testFirstConverter(pattern, ThreadNamePatternConverter.class);
    }

    private void testThreadPriorityPattern(String pattern) {
        this.testFirstConverter(pattern, ThreadPriorityPatternConverter.class);
    }

    private void testFirstConverter(String pattern, Class<?> checkClass) {
        List formatters = this.parser.parse(pattern);
        Assertions.assertNotNull((Object)formatters);
        String msg = formatters.toString();
        Assertions.assertEquals((int)1, (int)formatters.size(), (String)msg);
        Assertions.assertTrue((boolean)checkClass.isInstance(((PatternFormatter)formatters.get(0)).getConverter()), (String)msg);
    }

    @Test
    public void testThreadNameShortPattern() {
        this.testThreadNamePattern("%t");
    }

    @Test
    public void testNanoPatternShortChangesConfigurationNanoClock() {
        NullConfiguration config = new NullConfiguration();
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        PatternParser pp = new PatternParser((Configuration)config, KEY, null);
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        pp.parse("%m");
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        pp.parse("%nano");
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof SystemNanoClock));
    }

    @Test
    public void testNanoPatternLongChangesNanoClockFactoryMode() {
        NullConfiguration config = new NullConfiguration();
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        PatternParser pp = new PatternParser((Configuration)config, KEY, null);
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        pp.parse("%m");
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof DummyNanoClock));
        pp.parse("%N");
        Assertions.assertTrue((boolean)(config.getNanoClock() instanceof SystemNanoClock));
    }

    @Test
    public void testDeeplyNestedPattern() {
        List formatters = this.parser.parse("%notEmpty{ %maxLen{%X{var}}{3} }");
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)1, (int)formatters.size());
        StringMap mdc = ContextDataFactory.createContextData();
        mdc.putValue("var", (Object)"1234");
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setContextData(mdc).build();
        StringBuilder buf = new StringBuilder();
        ((PatternFormatter)formatters.get(0)).format((LogEvent)event, buf);
        String expected = " 123 ";
        Assertions.assertEquals((Object)" 123 ", (Object)buf.toString());
    }

    @Test
    public void testMissingClosingBracket() {
        this.testFirstConverter("%d{", DatePatternConverter.class);
    }

    @Test
    public void testClosingBracketButWrongPlace() {
        List formatters = this.parser.parse("}%d{");
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)2, (int)formatters.size());
        this.validateConverter(formatters, 0, "Literal");
        this.validateConverter(formatters, 1, "Date");
    }

    @Test
    public void testExceptionWithFilters() {
        List formatters = this.parser.parse("%d{DEFAULT} - %msg - %xEx{full}{filters(org.junit,org.eclipse)}%n");
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)6, (int)formatters.size());
        PatternFormatter patternFormatter = (PatternFormatter)formatters.get(4);
        LogEventPatternConverter converter = patternFormatter.getConverter();
        Assertions.assertEquals(ExtendedThrowablePatternConverter.class, converter.getClass());
        ExtendedThrowablePatternConverter exConverter = (ExtendedThrowablePatternConverter)converter;
        ThrowableFormatOptions options = exConverter.getOptions();
        Assertions.assertTrue((boolean)options.getIgnorePackages().contains("org.junit"));
        Assertions.assertTrue((boolean)options.getIgnorePackages().contains("org.eclipse"));
        Assertions.assertEquals((Object)System.lineSeparator(), (Object)options.getSeparator());
    }

    @Test
    public void testExceptionWithFiltersAndSeparator() {
        List formatters = this.parser.parse("%d{DEFAULT} - %msg - %xEx{full}{filters(org.junit,org.eclipse)}{separator(|)}%n");
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)6, (int)formatters.size());
        PatternFormatter patternFormatter = (PatternFormatter)formatters.get(4);
        LogEventPatternConverter converter = patternFormatter.getConverter();
        Assertions.assertEquals(ExtendedThrowablePatternConverter.class, converter.getClass());
        ExtendedThrowablePatternConverter exConverter = (ExtendedThrowablePatternConverter)converter;
        ThrowableFormatOptions options = exConverter.getOptions();
        List ignorePackages = options.getIgnorePackages();
        Assertions.assertNotNull((Object)ignorePackages);
        String ignorePackagesString = ignorePackages.toString();
        Assertions.assertTrue((boolean)ignorePackages.contains("org.junit"), (String)ignorePackagesString);
        Assertions.assertTrue((boolean)ignorePackages.contains("org.eclipse"), (String)ignorePackagesString);
        Assertions.assertEquals((Object)"|", (Object)options.getSeparator());
    }

    @Test
    public void testMapPatternConverter() {
        List formatters = this.parser.parse("%K");
        Assertions.assertNotNull((Object)formatters);
        Assertions.assertEquals((int)formatters.size(), (int)1);
        PatternFormatter formatter = (PatternFormatter)formatters.get(0);
        Assertions.assertTrue((boolean)(formatter.getConverter() instanceof MapPatternConverter), (String)"Expected a MapPatternConverter");
    }
}

