/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.apache.logging.log4j.util.Strings;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SocketReconnectTest {
    private static final int SOCKET_PORT1 = AvailablePortFinder.getNextAvailable();
    private static final int SOCKET_PORT2 = AvailablePortFinder.getNextAvailable();
    private static final String CONFIG = "log4j-socket.xml";
    private static final String SHUTDOWN = "Shutdown" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR + "................................................................" + Strings.LINE_SEPARATOR;
    public static LocalHostResolver resolver = new LocalHostResolver();
    private static LoggerContext loggerContext;
    private static final List<String> list;
    private static int[] ports;
    private static TestSocketServer server1;
    private static TestSocketServer server2;
    private static Logger logger;

    @BeforeAll
    public static void beforeClass() throws IOException, InterruptedException {
        server1 = new TestSocketServer(0);
        server2 = new TestSocketServer(0);
        server1.start();
        server2.start();
        Thread.sleep(100L);
        ports = new int[]{server1.getPort(), server2.getPort()};
        SocketReconnectTest.resolver.ports = ports;
        TcpSocketManager.setHostResolver((TcpSocketManager.HostResolver)resolver);
        loggerContext = Configurator.initialize((String)"SocketReconnectTest", (ClassLoader)SocketReconnectTest.class.getClassLoader(), (String)CONFIG);
        logger = LogManager.getLogger(SocketReconnectTest.class);
        server1.shutdown();
        server1.join();
        server2.shutdown();
        server2.join();
        server1 = null;
        server2 = null;
        Thread.sleep(100L);
        list.clear();
    }

    @AfterAll
    public static void afterClass() {
        Configurator.shutdown((LoggerContext)loggerContext);
    }

    @AfterEach
    public void after() throws InterruptedException {
        if (server1 != null) {
            server1.shutdown();
            server1.join();
        }
        if (server2 != null) {
            server2.shutdown();
            server2.join();
        }
        server1 = null;
        server2 = null;
        Thread.sleep(300L);
    }

    @Test
    public void testReconnect() throws Exception {
        int i;
        list.clear();
        SocketReconnectTest.resolver.ports = new int[]{ports[0]};
        server1 = new TestSocketServer(ports[0]);
        server1.start();
        Thread.sleep(200L);
        String message = "Log #1";
        String msg = null;
        for (int i2 = 0; i2 < 5; ++i2) {
            logger.error(message);
            Thread.sleep(100L);
            if (list.size() > 0 && (msg = list.get(0)) != null) break;
        }
        Assertions.assertNotNull(msg, (String)"No message");
        Assertions.assertEquals((Object)message, msg);
        logger.error(SHUTDOWN);
        server1.join();
        list.clear();
        message = "Log #2";
        boolean exceptionCaught = false;
        for (i = 0; i < 100; ++i) {
            try {
                logger.error(message);
                continue;
            }
            catch (AppenderLoggingException e) {
                exceptionCaught = true;
                break;
            }
        }
        Assertions.assertTrue((boolean)exceptionCaught, (String)"No Exception thrown");
        message = "Log #3";
        server1 = new TestSocketServer(ports[0]);
        server1.start();
        Thread.sleep(300L);
        msg = null;
        for (i = 0; i < 5; ++i) {
            logger.error(message);
            Thread.sleep(100L);
            if (list.size() > 0 && (msg = list.get(0)) != null) break;
        }
        Assertions.assertNotNull((Object)msg, (String)"No message");
        Assertions.assertEquals((Object)message, (Object)msg);
        logger.error(SHUTDOWN);
        server1.join();
    }

    @Test
    public void testFailover() throws Exception {
        int i;
        list.clear();
        server1 = new TestSocketServer(ports[0]);
        server2 = new TestSocketServer(ports[1]);
        SocketReconnectTest.resolver.ports = ports;
        server1.start();
        server2.start();
        Thread.sleep(100L);
        String message = "Log #1";
        String msg = null;
        for (i = 0; i < 5; ++i) {
            logger.error(message);
            Thread.sleep(100L);
            if (list.size() > 0 && (msg = list.get(0)) != null) break;
        }
        Assertions.assertNotNull(msg, (String)"No message");
        Assertions.assertEquals((Object)message, msg);
        server1.shutdown();
        server1.join();
        list.clear();
        message = "Log #2";
        for (i = 0; i < 5; ++i) {
            logger.error(message);
            Thread.sleep(100L);
            if (list.size() > 0 && (msg = list.get(0)) != null) break;
        }
        Assertions.assertNotNull((Object)msg, (String)"No message");
        Assertions.assertEquals((Object)message, (Object)msg);
        server2.shutdown();
        server2.join();
    }

    static {
        list = new ArrayList<String>();
    }

    private static class LocalHostResolver
    extends TcpSocketManager.HostResolver {
        public volatile int[] ports;

        private LocalHostResolver() {
        }

        public List<InetSocketAddress> resolveHost(String host, int port) throws UnknownHostException {
            int[] socketPorts = this.ports;
            ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(this.ports.length);
            InetAddress addr = InetAddress.getLocalHost();
            for (int i = 0; i < socketPorts.length; ++i) {
                socketAddresses.add(new InetSocketAddress(addr, socketPorts[i]));
            }
            return socketAddresses;
        }
    }

    private static class TestSocketServer
    extends Thread {
        private volatile boolean shutdown = false;
        private volatile boolean started = false;
        private volatile Socket client;
        private final int port;
        private ServerSocket server;

        public TestSocketServer(int port) throws IOException {
            this.port = port;
            this.server = new ServerSocket(port);
        }

        public int getPort() {
            return this.port == 0 ? this.server.getLocalPort() : this.port;
        }

        public void shutdown() {
            if (!this.shutdown) {
                this.shutdown = true;
                if (this.server != null && this.server.isBound()) {
                    try {
                        if (this.client != null) {
                            Socket serverClient = this.client;
                            this.client = null;
                            serverClient.shutdownInput();
                            serverClient.shutdownOutput();
                            serverClient.setSoLinger(true, 0);
                            serverClient.close();
                        }
                        ServerSocket serverSocket = this.server;
                        this.server = null;
                        serverSocket.close();
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to send shutdown message");
                        ex.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void run() {
            this.client = null;
            try {
                this.client = this.server.accept();
                this.started = true;
                while (!this.shutdown) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                    String line = reader.readLine();
                    if (line == null || line.equals("Shutdown")) {
                        this.shutdown = true;
                        continue;
                    }
                    list.add(line);
                }
            }
            catch (SocketException ex) {
                if (!this.shutdown) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (this.client != null && !this.client.isClosed()) {
                    try {
                        this.client.setSoLinger(true, 0);
                        this.client.shutdownOutput();
                        this.client.close();
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to close socket: " + ex.getMessage());
                    }
                }
                if (this.server != null && !this.server.isClosed()) {
                    try {
                        this.server.close();
                    }
                    catch (Exception ex) {
                        System.out.println("Unable to close server socket: " + ex.getMessage());
                    }
                }
            }
        }
    }
}

