/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;

public class SpyByteBufferDestination
implements ByteBufferDestination {
    public final ByteBuffer buffer;
    public final ByteBuffer drained;
    public final List<Data> drainPoints = new ArrayList<Data>();

    public SpyByteBufferDestination(int bufferSize, int destinationSize) {
        this.buffer = ByteBuffer.wrap(new byte[bufferSize]);
        this.drained = ByteBuffer.wrap(new byte[destinationSize]);
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer drain(ByteBuffer buf) {
        buf.flip();
        this.drainPoints.add(new Data(buf.position(), buf.limit()));
        this.drained.put(buf);
        buf.clear();
        return buf;
    }

    public void writeBytes(ByteBuffer data) {
        ByteBufferDestinationHelper.writeToUnsynchronized((ByteBuffer)data, (ByteBufferDestination)this);
    }

    public void writeBytes(byte[] data, int offset, int length) {
        ByteBufferDestinationHelper.writeToUnsynchronized((byte[])data, (int)offset, (int)length, (ByteBufferDestination)this);
    }

    public static class Data {
        public final int position;
        public final int limit;

        public Data(int position, int limit) {
            this.position = position;
            this.limit = limit;
        }

        public int length() {
            return this.limit - this.position;
        }
    }
}

