/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class Log4j2Jira1688AsyncTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j-list.xml");
    private ListAppender listAppender;

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "log4j-list.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Before
    public void before() throws Exception {
        this.listAppender = this.context.getListAppender("List");
    }

    private static Object[] createArray(int size) {
        Object[] args = new Object[size];
        for (int i = 0; i < args.length; ++i) {
            args[i] = i;
        }
        return args;
    }

    @Test
    public void testLog4j2Only() throws InterruptedException {
        Logger log4JLogger = LogManager.getLogger(this.getClass());
        int limit = 11;
        Object[] args = Log4j2Jira1688AsyncTest.createArray(11);
        Object[] originalArgs = Arrays.copyOf(args, args.length);
        this.listAppender.countDownLatch = new CountDownLatch(1);
        ((ExtendedLogger)log4JLogger).logIfEnabled("test", Level.ERROR, null, "test {}", args);
        this.listAppender.countDownLatch.await(1L, TimeUnit.SECONDS);
        Assert.assertArrayEquals((String)Arrays.toString(args), (Object[])originalArgs, (Object[])args);
        ((ExtendedLogger)log4JLogger).logIfEnabled("test", Level.ERROR, null, "test {}", args);
        Assert.assertArrayEquals((String)Arrays.toString(args), (Object[])originalArgs, (Object[])args);
    }
}

