/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverListener;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RollingDirectSizeTimeNewDirectoryTest
implements RolloverListener {
    private static final String CONFIG = "log4j-rolling-size-time-new-directory.xml";
    private static final String DIR = "target/rolling-size-time-new-directory";
    public static LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-size-time-new-directory.xml");
    @Rule
    public RuleChain chain = loggerContextRule.withCleanFoldersRule("target/rolling-size-time-new-directory");
    private Map<String, AtomicInteger> rolloverFiles = new HashMap<String, AtomicInteger>();

    @Test
    public void streamClosedError() throws Exception {
        int i;
        ((RollingFileManager)((RollingFileAppender)loggerContextRule.getAppender("RollingFile")).getManager()).addRolloverListener((RolloverListener)this);
        Logger logger = loggerContextRule.getLogger(RollingDirectSizeTimeNewDirectoryTest.class);
        for (i = 0; i < 1000; ++i) {
            logger.info("nHq6p9kgfvWfjzDRYbZp");
        }
        Thread.sleep(1500L);
        for (i = 0; i < 1000; ++i) {
            logger.info("nHq6p9kgfvWfjzDRYbZp");
        }
        Assert.assertTrue((String)"A time based rollover did not occur", (this.rolloverFiles.size() > 1 ? 1 : 0) != 0);
        int maxFiles = Collections.max(this.rolloverFiles.values(), Comparator.comparing(AtomicInteger::get)).get();
        Assert.assertTrue((String)"No size based rollovers occurred", (maxFiles > 1 ? 1 : 0) != 0);
    }

    public void rolloverTriggered(String fileName) {
    }

    public void rolloverComplete(String fileName) {
        File file = new File(fileName);
        String logDir = file.getParentFile().getName();
        AtomicInteger fileCount = this.rolloverFiles.computeIfAbsent(logDir, k -> new AtomicInteger(0));
        fileCount.incrementAndGet();
    }
}

