/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class ShutdownCallbackRegistryTest {
    @Rule
    public final LoggerContextRule ctx = new LoggerContextRule("ShutdownCallbackRegistryTest.xml");

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("log4j2.is.webapp", "false");
        System.setProperty("log4j.shutdownCallbackRegistry", Registry.class.getName());
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("log4j.shutdownCallbackRegistry");
        System.clearProperty("log4j2.is.webapp");
    }

    @Test
    public void testShutdownCallbackRegistry() throws Exception {
        LoggerContext context = this.ctx.getLoggerContext();
        Assert.assertTrue((String)"LoggerContext should be started", (boolean)context.isStarted());
        Assert.assertThat((Object)Registry.CALLBACKS, (Matcher)Matchers.hasSize((int)1));
        Registry.shutdown();
        Assert.assertTrue((String)"LoggerContext should be stopped", (boolean)context.isStopped());
        Assert.assertThat((Object)Registry.CALLBACKS, (Matcher)Matchers.hasSize((int)0));
        ContextSelector selector = ((Log4jContextFactory)LogManager.getFactory()).getSelector();
        Assert.assertThat((Object)selector.getLoggerContexts(), (Matcher)Matchers.not((Matcher)Matchers.hasItem((Object)context)));
    }

    public static class Registry
    implements ShutdownCallbackRegistry {
        private static final Logger LOGGER = StatusLogger.getLogger();
        private static final Collection<Cancellable> CALLBACKS = new ConcurrentLinkedQueue<Cancellable>();

        public Cancellable addShutdownCallback(final Runnable callback) {
            Cancellable cancellable = new Cancellable(){

                public void cancel() {
                    LOGGER.debug("Cancelled shutdown callback: {}", (Object)callback);
                    CALLBACKS.remove(this);
                }

                public void run() {
                    LOGGER.debug("Called shutdown callback: {}", (Object)callback);
                    callback.run();
                }
            };
            CALLBACKS.add(cancellable);
            return cancellable;
        }

        private static void shutdown() {
            for (Runnable runnable : CALLBACKS) {
                LOGGER.debug("Calling shutdown callback: {}", (Object)runnable);
                runnable.run();
            }
            CALLBACKS.clear();
        }
    }
}

