/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.MapFilter;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MapFilterTest {
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j2-mapfilter.xml");

    @Test
    public void testFilter() {
        KeyValuePair[] pairs = new KeyValuePair[]{new KeyValuePair("FromAccount", "211000"), new KeyValuePair("ToAccount", "123456")};
        MapFilter filter = MapFilter.createFilter((KeyValuePair[])pairs, (String)"and", null, null);
        filter.start();
        StringMapMessage msg = new StringMapMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
        filter = MapFilter.createFilter((KeyValuePair[])pairs, (String)"or", null, null);
        filter.start();
        msg = new StringMapMessage();
        msg.put("ToAccount", "123456");
        msg.put("FromAccount", "211000");
        msg.put("Amount", "1000.00");
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.DEBUG, null, (Message)msg, null));
        msg.put("ToAccount", "111111");
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, (Message)msg, null));
    }

    @Test
    public void testConfig() {
        Configuration config = context.getConfiguration();
        Filter filter = config.getFilter();
        Assert.assertNotNull((String)"No MapFilter", (Object)filter);
        Assert.assertTrue((String)"Not a MapFilter", (boolean)(filter instanceof MapFilter));
        MapFilter mapFilter = (MapFilter)filter;
        Assert.assertFalse((String)"Should not be And filter", (boolean)mapFilter.isAnd());
        Map map = mapFilter.getMap();
        Assert.assertNotNull((String)"No Map", (Object)map);
        Assert.assertFalse((String)"No elements in Map", (boolean)map.isEmpty());
        Assert.assertEquals((String)"Incorrect number of elements in Map", (long)1L, (long)map.size());
        Assert.assertTrue((String)"Map does not contain key eventId", (boolean)map.containsKey("eventId"));
        Assert.assertEquals((String)"List does not contain 2 elements", (long)2L, (long)((List)map.get("eventId")).size());
        Logger logger = LogManager.getLogger(MapFilterTest.class);
        HashMap<String, String> eventMap = new HashMap<String, String>();
        eventMap.put("eventId", "Login");
        logger.debug((Message)new StringMapMessage(eventMap));
        ListAppender app = context.getListAppender("LIST");
        List<String> msgs = app.getMessages();
        Assert.assertNotNull((String)"No messages", msgs);
        Assert.assertFalse((String)"No messages", (boolean)msgs.isEmpty());
    }
}

