/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XIncludeTest {
    private static final String LOGGER_NAME = "org.apache.logging.log4j.test1.Test";
    private static final String FILE_LOGGER_NAME = "org.apache.logging.log4j.test2.Test";
    private static final String APPENDER_NAME = "STDOUT";
    private final String logFileName;
    @Rule
    public TestRule rules;
    private final LoggerContextRule init;
    private LoggerContext ctx;
    private final SecureRandom random = new SecureRandom();

    public XIncludeTest(String configFileName, String logFileName) {
        this.logFileName = logFileName;
        this.init = new LoggerContextRule(configFileName);
        this.rules = RuleChain.outerRule((TestRule)new CleanFiles(logFileName)).around((TestRule)this.init);
    }

    @Parameterized.Parameters(name="config={0}, log={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"classpath:log4j-xinclude.xml", "target/test-xinclude.log"}});
    }

    @Before
    public void setUp() throws Exception {
        this.ctx = this.init.getLoggerContext();
    }

    @Test
    public void testConfiguredAppenders() throws Exception {
        Configuration configuration = this.ctx.getConfiguration();
        Map appenders = configuration.getAppenders();
        Assert.assertThat((Object)appenders, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)appenders.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
    }

    @Test
    public void testLogger() throws Exception {
        Logger logger = this.ctx.getLogger(LOGGER_NAME);
        Assert.assertThat((Object)logger, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(Logger.class)));
        Logger l = logger;
        Assert.assertThat((Object)l.getLevel(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)Level.DEBUG)));
        Assert.assertThat((Object)l.filterCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Iterator iterator = l.getFilters();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        Filter filter = (Filter)iterator.next();
        Assert.assertThat((Object)filter, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ThreadContextMapFilter.class)));
        Map appenders = l.getAppenders();
        Assert.assertThat((Object)appenders, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)appenders, MapMatchers.hasSize(1));
        Appender appender = (Appender)appenders.get(APPENDER_NAME);
        Assert.assertThat((Object)appender, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)appender.getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)APPENDER_NAME)));
    }

    @Test
    public void testLogToFile() throws Exception {
        Logger logger = this.ctx.getLogger(FILE_LOGGER_NAME);
        long random = this.random.nextLong();
        logger.debug("This is test message number {}", (Object)random);
        int count = 0;
        String line = "";
        try (BufferedReader in = new BufferedReader(new FileReader(this.logFileName));){
            while (in.ready()) {
                ++count;
                line = in.readLine();
            }
        }
        Assert.assertThat((Object)count, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        Assert.assertThat((Object)line, (Matcher)Matchers.endsWith((String)Long.toString(random)));
    }
}

