/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.categories.Scripts;
import org.apache.logging.log4j.core.appender.rolling.action.DummyFileAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.ScriptCondition;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.Script;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ScriptConditionTest {
    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNullScript() {
        new ScriptCondition(null, (Configuration)new DefaultConfiguration());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNullConfig() {
        new ScriptCondition((AbstractScript)new Script("test", "js", "print('hi')"), null);
    }

    @Test
    public void testCreateConditionReturnsNullForNullScript() {
        Assert.assertNull((Object)ScriptCondition.createCondition(null, (Configuration)new DefaultConfiguration()));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateConditionDisallowsNullConfig() {
        ScriptCondition.createCondition((AbstractScript)new Script("test", "js", "print('hi')"), null);
    }

    @Test
    public void testSelectFilesToDelete() {
        DefaultConfiguration config = new DefaultConfiguration();
        config.initialize();
        Script script = new Script("test", "javascript", "pathList;");
        ScriptCondition condition = new ScriptCondition((AbstractScript)script, (Configuration)config);
        ArrayList pathList = new ArrayList();
        Path base = Paths.get("baseDirectory", new String[0]);
        List result = condition.selectFilesToDelete(base, pathList);
        Assert.assertSame((Object)result, pathList);
    }

    @Test
    public void testSelectFilesToDelete2() {
        DefaultConfiguration config = new DefaultConfiguration();
        config.initialize();
        ArrayList<PathWithAttributes> pathList = new ArrayList<PathWithAttributes>();
        pathList.add(new PathWithAttributes(Paths.get("/path/1", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        pathList.add(new PathWithAttributes(Paths.get("/path/2", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        pathList.add(new PathWithAttributes(Paths.get("/path/3", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        String scriptText = "pathList.remove(1);pathList;";
        Script script = new Script("test", "javascript", "pathList.remove(1);pathList;");
        ScriptCondition condition = new ScriptCondition((AbstractScript)script, (Configuration)config);
        Path base = Paths.get("baseDirectory", new String[0]);
        List result = condition.selectFilesToDelete(base, pathList);
        Assert.assertSame((Object)result, pathList);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)Paths.get("/path/1", new String[0]), (Object)((PathWithAttributes)result.get(0)).getPath());
        Assert.assertEquals((Object)Paths.get("/path/3", new String[0]), (Object)((PathWithAttributes)result.get(1)).getPath());
    }

    @Test
    @Category(value={Scripts.Groovy.class})
    public void testSelectFilesToDelete3() {
        DefaultConfiguration config = new DefaultConfiguration();
        config.initialize();
        ArrayList<PathWithAttributes> pathList = new ArrayList<PathWithAttributes>();
        pathList.add(new PathWithAttributes(Paths.get("/path/1/abc/a.txt", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        pathList.add(new PathWithAttributes(Paths.get("/path/2/abc/bbb.txt", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        pathList.add(new PathWithAttributes(Paths.get("/path/3/abc/c.txt", new String[0]), (BasicFileAttributes)new DummyFileAttributes()));
        String scriptText = "import java.nio.file.*;def pattern = ~/(\\d*)[\\/\\\\]abc[\\/\\\\].*\\.txt/;assert pattern.getClass() == java.util.regex.Pattern;def copy = pathList.collect{it};pathList.each { pathWithAttribs -> \n  def relative = basePath.relativize pathWithAttribs.path;  println 'relative path: ' + relative;  def str = relative.toString();  def m = pattern.matcher(str);  if (m.find()) {    def index = m.group(1) as int;    println 'extracted index: ' + index;    def isOdd = (index % 2) == 1;    println 'is odd: ' + isOdd;    if (isOdd) { copy.remove pathWithAttribs}  }}println copy;copy;";
        Script script = new Script("test", "groovy", "import java.nio.file.*;def pattern = ~/(\\d*)[\\/\\\\]abc[\\/\\\\].*\\.txt/;assert pattern.getClass() == java.util.regex.Pattern;def copy = pathList.collect{it};pathList.each { pathWithAttribs -> \n  def relative = basePath.relativize pathWithAttribs.path;  println 'relative path: ' + relative;  def str = relative.toString();  def m = pattern.matcher(str);  if (m.find()) {    def index = m.group(1) as int;    println 'extracted index: ' + index;    def isOdd = (index % 2) == 1;    println 'is odd: ' + isOdd;    if (isOdd) { copy.remove pathWithAttribs}  }}println copy;copy;");
        ScriptCondition condition = new ScriptCondition((AbstractScript)script, (Configuration)config);
        Path base = Paths.get("/path", new String[0]);
        List result = condition.selectFilesToDelete(base, pathList);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)Paths.get("/path/2/abc/bbb.txt", new String[0]), (Object)((PathWithAttributes)result.get(0)).getPath());
    }
}

