/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class PropertiesFileConfigTest {
    private static final String CONFIG = "target/test-classes/log4j-test2.properties";
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("target/test-classes/log4j-test2.properties");
    private final Logger logger = context.getLogger("LoggerTest");

    @Before
    public void before() {
        context.getListAppender("List").clear();
    }

    @Test
    public void testReconfiguration() throws Exception {
        Configuration newConfig;
        Configuration oldConfig = context.getConfiguration();
        int MONITOR_INTERVAL_SECONDS = 5;
        File file = new File(CONFIG);
        long orig = file.lastModified();
        long newTime = orig + 10000L;
        Assert.assertTrue((String)"setLastModified should have succeeded.", (boolean)file.setLastModified(newTime));
        TimeUnit.SECONDS.sleep(6L);
        for (int i = 0; i < 17; ++i) {
            this.logger.info("Reconfigure");
        }
        int loopCount = 0;
        do {
            Thread.sleep(100L);
        } while ((newConfig = context.getConfiguration()) == oldConfig && loopCount++ < 5);
        Assert.assertNotSame((String)"Reconfiguration failed", (Object)newConfig, (Object)oldConfig);
    }
}

