/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.logging.log4j.util.Strings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class HostNameTest {
    private static final String CONFIG = "log4j-test2.xml";
    private ListAppender host;
    private RollingFileAppender hostFile;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-test2.xml");

    @Before
    public void before() {
        this.host = context.getListAppender("HostTest").clear();
        this.hostFile = context.getRequiredAppender("HostFile", RollingFileAppender.class);
    }

    @Test
    public void testHostname() {
        Logger testLogger = context.getLogger("org.apache.logging.log4j.hosttest");
        testLogger.debug("Hello, {}", (Object)"World");
        List<String> msgs = this.host.getMessages();
        Assert.assertThat(msgs, (Matcher)Matchers.hasSize((int)1));
        String expected = NetUtils.getLocalHostname() + Strings.LINE_SEPARATOR;
        Assert.assertThat((Object)msgs.get(0), (Matcher)Matchers.endsWith((String)expected));
        Assert.assertNotNull((String)"No Host FileAppender file name", (Object)this.hostFile.getFileName());
        expected = "target/" + NetUtils.getLocalHostname() + ".log";
        String name = this.hostFile.getFileName();
        Assert.assertEquals((String)("Incorrect HostFile FileAppender file name - expected " + expected + " actual - " + name), (Object)name, (Object)expected);
        name = this.hostFile.getFilePattern();
        Assert.assertNotNull((String)"No file pattern", (Object)name);
        expected = "target/" + NetUtils.getLocalHostname() + "-%d{MM-dd-yyyy}-%i.log";
        Assert.assertEquals((String)("Incorrect HostFile FileAppender file pattern - expected " + expected + " actual - " + name), (Object)name, (Object)expected);
    }
}

