/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class InterpolatorTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTKEY2 = "TestKey2";
    private static final String TESTVAL = "TestValue";
    @ClassRule
    public static RuleChain rules = RuleChain.outerRule((TestRule)new ExternalResource(){

        protected void before() throws Throwable {
            System.setProperty(InterpolatorTest.TESTKEY, InterpolatorTest.TESTVAL);
            System.setProperty(InterpolatorTest.TESTKEY2, InterpolatorTest.TESTVAL);
            System.setProperty("log4j2.enableJndiLookup", "true");
        }

        protected void after() {
            System.clearProperty(InterpolatorTest.TESTKEY);
            System.clearProperty(InterpolatorTest.TESTKEY2);
            System.clearProperty("log4j2.enableJndiLookup");
        }
    });

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = lookup.lookup(TESTKEY);
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("ctx:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("sys:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("SYS:TestKey2");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("BadKey");
        Assert.assertNull((Object)value);
        ThreadContext.clearMap();
        value = lookup.lookup("ctx:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
    }

    private void assertLookupNotEmpty(StrLookup lookup, String key) {
        String value = lookup.lookup(key);
        Assert.assertNotNull((Object)value);
        Assert.assertFalse((boolean)value.isEmpty());
        System.out.println(key + " = " + value);
    }

    @Test
    public void testLookupWithDefaultInterpolator() {
        Interpolator lookup = new Interpolator();
        String value = lookup.lookup("sys:TestKey");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
        value = lookup.lookup("env:PATH");
        Assert.assertNotNull((Object)value);
        value = lookup.lookup("date:yyyy-MM-dd");
        Assert.assertNotNull((String)"No Date", (Object)value);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String today = format.format(new Date());
        Assert.assertEquals((Object)value, (Object)today);
        this.assertLookupNotEmpty((StrLookup)lookup, "java:version");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:runtime");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:vm");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:os");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:locale");
        this.assertLookupNotEmpty((StrLookup)lookup, "java:hw");
    }
}

