/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class LevelRangeFilterTest {
    @Test
    public void testLevels() {
        LevelRangeFilter filter = LevelRangeFilter.createFilter((Level)Level.ERROR, (Level)Level.INFO, null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter(null, Level.DEBUG, null, null, (Throwable)null));
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Test")).build();
        Assert.assertSame((Object)Filter.Result.DENY, (Object)filter.filter((LogEvent)event));
        event = Log4jLogEvent.newBuilder().setLevel(Level.ERROR).setMessage((Message)new SimpleMessage("Test")).build();
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter((LogEvent)event));
    }

    @Test
    public void testMinimumOnlyLevel() {
        LevelRangeFilter filter = LevelRangeFilter.createFilter((Level)Level.ERROR, null, null, null);
        filter.start();
        Assert.assertTrue((boolean)filter.isStarted());
        Assert.assertSame((Object)Filter.Result.NEUTRAL, (Object)filter.filter(null, Level.ERROR, null, null, (Throwable)null));
    }
}

