/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigAutoFlushTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigAutoFlushTest.xml");
    }

    @Test
    public void testFlushAtEndOfBatch() throws Exception {
        File file = new File("target", "AsyncLoggerConfigAutoFlushTest.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        String msg = "Message flushed with immediate flush=false";
        log.info("Message flushed with immediate flush=false");
        CoreLoggerContexts.stopLoggerContext(file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.contains("Message flushed with immediate flush=false"));
    }
}

