/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;

public class RolloverWithDeletedOldFileTest {
    private static final String CONFIG = "log4j-rolling-with-padding.xml";
    private static final String DIR = "target/rolling-with-padding";
    private final LoggerContextRule loggerContextRule = LoggerContextRule.createShutdownTimeoutLoggerContextRule("log4j-rolling-with-padding.xml");
    @Rule
    public RuleChain chain = this.loggerContextRule.withCleanFoldersRule("target/rolling-with-padding");

    @Test
    public void testAppender() throws Exception {
        Logger logger = this.loggerContextRule.getLogger();
        for (int i = 0; i < 10; ++i) {
            logger.fatal("This is a test message number " + i);
        }
        Thread.sleep(100L);
        File dir = new File(DIR);
        Assert.assertTrue((String)"Dir target/rolling-with-padding should exist", (boolean)dir.exists());
        Assert.assertTrue((String)"Dir target/rolling-with-padding should contain files", (dir.listFiles().length == 6 ? 1 : 0) != 0);
        File[] files = dir.listFiles();
        List<String> expected = Arrays.asList("rollingtest.log", "test-001.log", "test-002.log", "test-003.log", "test-004.log", "test-005.log");
        Assert.assertEquals((String)"Unexpected number of files", (long)expected.size(), (long)files.length);
        File fileToRemove = null;
        for (File file : files) {
            if (!expected.contains(file.getName())) {
                Assert.fail((String)("unexpected file" + file));
            }
            if (!file.getName().equals("test-001.log")) continue;
            fileToRemove = file;
        }
        fileToRemove.delete();
        for (int i = 0; i < 10; ++i) {
            logger.fatal("This is a test message number " + i);
        }
        Thread.sleep(100L);
        files = dir.listFiles();
        Assert.assertEquals((String)"Unexpected number of files", (long)expected.size(), (long)files.length);
        for (File file : files) {
            if (expected.contains(file.getName())) continue;
            Assert.fail((String)("unexpected file" + file));
        }
    }
}

