/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SocketAppenderTest {
    private static final int PORT = AvailablePortFinder.getNextAvailable();
    private static final int DYN_PORT = AvailablePortFinder.getNextAvailable();
    private static final int ERROR_PORT = AvailablePortFinder.getNextAvailable();
    private static TcpSocketTestServer tcpServer;
    private static UdpSocketTestServer udpServer;
    private final LoggerContext context = LoggerContext.getContext();
    private final Logger logger = this.context.getLogger(SocketAppenderTest.class.getName());

    @BeforeClass
    public static void setupClass() throws Exception {
        tcpServer = new TcpSocketTestServer(PORT);
        tcpServer.start();
        udpServer = new UdpSocketTestServer();
        udpServer.start();
        LoggerContext.getContext().reconfigure();
        ThreadContext.clearAll();
    }

    @AfterClass
    public static void cleanupClass() {
        tcpServer.shutdown();
        udpServer.shutdown();
        ThreadContext.clearAll();
    }

    @After
    public void teardown() {
        ThreadContext.clearAll();
        this.removeAndStopAppenders();
        SocketAppenderTest.reset();
    }

    void removeAndStopAppenders() {
        Map map = this.logger.getAppenders();
        for (Map.Entry entry : map.entrySet()) {
            Appender appender = (Appender)entry.getValue();
            this.logger.removeAppender(appender);
            appender.stop();
        }
    }

    static void reset() {
        tcpServer.reset();
        udpServer.reset();
    }

    @Test
    public void testTcpAppender1() throws Exception {
        SocketAppenderTest.testTcpAppender(tcpServer, this.logger, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    @Test
    @Ignore(value="WIP Bug when this method runs after testTcpAppender1()")
    public void testTcpAppender2() throws Exception {
        SocketAppenderTest.testTcpAppender(tcpServer, this.logger, Constants.ENCODER_BYTE_BUFFER_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testTcpAppender(TcpSocketTestServer tcpTestServer, Logger logger, int bufferSize) throws Exception {
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withHost("localhost")).withPort(tcpTestServer.getLocalPort())).withReconnectDelayMillis(-1)).setName("test")).withImmediateFail(false)).withBufferSize(bufferSize)).setLayout((Layout)((JsonLayout.Builder)JsonLayout.newBuilder().setProperties(true)).build())).build();
        appender.start();
        Assert.assertEquals((long)bufferSize, (long)((AbstractSocketManager)appender.getManager()).getByteBuffer().capacity());
        logger.addAppender((Appender)appender);
        logger.setAdditive(false);
        logger.setLevel(Level.DEBUG);
        String tcKey = "UUID";
        String expectedUuidStr = UUID.randomUUID().toString();
        ThreadContext.put((String)"UUID", (String)expectedUuidStr);
        ThreadContext.push((String)expectedUuidStr);
        String expectedExMsg = "This is a test";
        try {
            logger.debug("This is a test message");
            LoggingException child = new LoggingException("This is a test");
            logger.error("Throwing an exception", (Throwable)child);
            logger.debug("This is another test message");
        }
        finally {
            ThreadContext.remove((String)"UUID");
            ThreadContext.pop();
        }
        Thread.sleep(250L);
        LogEvent event = tcpTestServer.getQueue().poll(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No event retrieved", (Object)event);
        Assert.assertTrue((String)"Incorrect event", (boolean)event.getMessage().getFormattedMessage().equals("This is a test message"));
        Assert.assertTrue((String)"Message not delivered via TCP", (tcpTestServer.getCount() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedUuidStr, (Object)event.getContextData().getValue("UUID"));
        event = tcpTestServer.getQueue().poll(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No event retrieved", (Object)event);
        Assert.assertTrue((String)"Incorrect event", (boolean)event.getMessage().getFormattedMessage().equals("Throwing an exception"));
        Assert.assertTrue((String)"Message not delivered via TCP", (tcpTestServer.getCount() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedUuidStr, (Object)event.getContextStack().pop());
        Assert.assertNotNull((Object)event.getThrownProxy());
        Assert.assertEquals((Object)"This is a test", (Object)event.getThrownProxy().getMessage());
    }

    @Test
    public void testDefaultProtocol() throws Exception {
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withPort(tcpServer.getLocalPort())).withReconnectDelayMillis(-1)).setName("test")).withImmediateFail(false)).setLayout((Layout)((JsonLayout.Builder)JsonLayout.newBuilder().setProperties(true)).build())).build();
        Assert.assertNotNull((Object)appender);
        appender.stop();
    }

    @Test
    public void testUdpAppender() throws Exception {
        try {
            udpServer.latch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withProtocol(Protocol.UDP)).withPort(tcpServer.getLocalPort())).withReconnectDelayMillis(-1)).setName("test")).withImmediateFail(false)).setLayout((Layout)((JsonLayout.Builder)JsonLayout.newBuilder().setProperties(true)).build())).build();
        appender.start();
        this.logger.addAppender((Appender)appender);
        this.logger.setAdditive(false);
        this.logger.setLevel(Level.DEBUG);
        this.logger.debug("This is a udp message");
        LogEvent event = udpServer.getQueue().poll(3L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"No event retrieved", (Object)event);
        Assert.assertTrue((String)"Incorrect event", (boolean)event.getMessage().getFormattedMessage().equals("This is a udp message"));
        Assert.assertTrue((String)"Message not delivered via UDP", (udpServer.getCount() > 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTcpAppenderDeadlock() throws Exception {
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withHost("localhost")).withPort(DYN_PORT)).withReconnectDelayMillis(100)).setName("test")).withImmediateFail(false)).setLayout((Layout)((JsonLayout.Builder)JsonLayout.newBuilder().setProperties(true)).build())).build();
        appender.start();
        this.logger.addAppender((Appender)appender);
        this.logger.setAdditive(false);
        this.logger.setLevel(Level.DEBUG);
        TcpSocketTestServer tcpSocketServer = new TcpSocketTestServer(DYN_PORT);
        try {
            tcpSocketServer.start();
            this.logger.debug("This message is written because a deadlock never.");
            LogEvent event = tcpSocketServer.getQueue().poll(3L, TimeUnit.SECONDS);
            Assert.assertNotNull((String)"No event retrieved", (Object)event);
        }
        finally {
            tcpSocketServer.shutdown();
        }
    }

    @Test
    public void testTcpAppenderNoWait() throws Exception {
        SocketAppender appender = ((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)((SocketAppender.Builder)SocketAppender.newBuilder().withHost("localhost")).withPort(ERROR_PORT)).withReconnectDelayMillis(100)).setName("test")).withImmediateFail(false)).setIgnoreExceptions(false)).setLayout((Layout)((JsonLayout.Builder)JsonLayout.newBuilder().setProperties(true)).build())).build();
        appender.start();
        this.logger.addAppender((Appender)appender);
        this.logger.setAdditive(false);
        this.logger.setLevel(Level.DEBUG);
        try {
            this.logger.debug("This message is written because a deadlock never.");
            Assert.fail((String)"No Exception was thrown");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TcpSocketTestServer
    extends Thread {
        private final ServerSocket serverSocket;
        private volatile boolean shutdown = false;
        private volatile int count = 0;
        private final BlockingQueue<LogEvent> queue;
        private final ObjectMapper objectMapper = new Log4jJsonObjectMapper();

        public TcpSocketTestServer(int port) throws IOException {
            this(new ServerSocket(port));
        }

        public TcpSocketTestServer(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.queue = new ArrayBlockingQueue<LogEvent>(10);
        }

        public int getLocalPort() {
            return this.serverSocket.getLocalPort();
        }

        public void reset() {
            this.queue.clear();
            this.count = 0;
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
            try {
                this.join(100L);
            }
            catch (InterruptedException ie) {
                System.out.println("Unable to stop server");
            }
        }

        @Override
        public void run() {
            block18: {
                try (Socket socket2 = this.serverSocket.accept();){
                    if (socket2 != null) {
                        InputStream is = socket2.getInputStream();
                        while (!this.shutdown) {
                            MappingIterator mappingIterator = this.objectMapper.readerFor(Log4jLogEvent.class).readValues(is);
                            while (mappingIterator.hasNextValue()) {
                                this.queue.add((LogEvent)mappingIterator.nextValue());
                                ++this.count;
                            }
                        }
                    }
                }
                catch (EOFException socket2) {
                }
                catch (Exception e) {
                    if (this.shutdown) break block18;
                    Throwables.rethrow((Throwable)e);
                }
            }
        }

        public BlockingQueue<LogEvent> getQueue() {
            return this.queue;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class UdpSocketTestServer
    extends Thread {
        private final DatagramSocket sock;
        private boolean shutdown = false;
        private Thread thread;
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile int count = 0;
        private final BlockingQueue<LogEvent> queue;
        private final ObjectMapper objectMapper = new Log4jJsonObjectMapper();

        public UdpSocketTestServer() throws IOException {
            this.sock = new DatagramSocket(PORT);
            this.queue = new ArrayBlockingQueue<LogEvent>(10);
        }

        public void reset() {
            this.queue.clear();
            this.count = 0;
        }

        public void shutdown() {
            this.shutdown = true;
            this.thread.interrupt();
            try {
                this.thread.join(100L);
            }
            catch (InterruptedException ie) {
                System.out.println("Unable to stop server");
            }
        }

        @Override
        public void run() {
            block3: {
                this.thread = Thread.currentThread();
                byte[] bytes = new byte[4096];
                DatagramPacket packet = new DatagramPacket(bytes, bytes.length);
                try {
                    while (!this.shutdown) {
                        this.latch.countDown();
                        this.sock.receive(packet);
                        ++this.count;
                        LogEvent event = (LogEvent)this.objectMapper.readValue(packet.getData(), Log4jLogEvent.class);
                        this.queue.add(event);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (this.shutdown) break block3;
                    Throwables.rethrow((Throwable)e);
                }
            }
        }

        public int getCount() {
            return this.count;
        }

        public BlockingQueue<LogEvent> getQueue() {
            return this.queue;
        }
    }
}

