/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryMappedFileAppenderSimpleTest {
    final String LOGFILE = "target/MemoryMappedFileAppenderTest.log";

    @Before
    public void before() {
        System.setProperty("log4j.configurationFile", "MemoryMappedFileAppenderTest.xml");
    }

    @Test
    public void testMemMapBasics() throws Exception {
        String line3;
        String line2;
        String line1;
        File f = new File("target/MemoryMappedFileAppenderTest.log");
        if (f.exists()) {
            Assert.assertTrue((boolean)f.delete());
        }
        Assert.assertTrue((!f.exists() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger();
        try {
            log.warn("Test log1");
            Assert.assertTrue((boolean)f.exists());
            Assert.assertEquals((String)"initial length", (long)0x2000000L, (long)f.length());
            log.warn("Test log2");
            Assert.assertEquals((String)"not grown", (long)0x2000000L, (long)f.length());
        }
        finally {
            CoreLoggerContexts.stopLoggerContext(false);
        }
        int LINESEP = System.lineSeparator().length();
        Assert.assertEquals((String)"Shrunk to actual used size", (long)(186 + 2 * LINESEP), (long)f.length());
        try (BufferedReader reader = new BufferedReader(new FileReader("target/MemoryMappedFileAppenderTest.log"));){
            line1 = reader.readLine();
            line2 = reader.readLine();
            line3 = reader.readLine();
        }
        Assert.assertNotNull((Object)line1);
        Assert.assertThat((Object)line1, (Matcher)CoreMatchers.containsString((String)"Test log1"));
        Assert.assertNotNull((Object)line2);
        Assert.assertThat((Object)line2, (Matcher)CoreMatchers.containsString((String)"Test log2"));
        Assert.assertNull((String)"only two lines were logged", (Object)line3);
    }
}

