/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.util.HashMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.MapLookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StrSubstitutorTest {
    private static final String TESTKEY = "TestKey";
    private static final String TESTVAL = "TestValue";

    @BeforeClass
    public static void before() {
        System.setProperty(TESTKEY, TESTVAL);
    }

    @AfterClass
    public static void after() {
        System.clearProperty(TESTKEY);
    }

    @Test
    public void testLookup() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${TestKey}-${ctx:TestKey}-${sys:TestKey}");
        Assert.assertEquals((Object)"TestValue-TestValue-TestValue", (Object)value);
        value = subst.replace("${BadKey}");
        Assert.assertEquals((Object)"${BadKey}", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-Unknown}-${sys:BadKey:-Unknown}");
        Assert.assertEquals((Object)"Unknown-Unknown-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey}-${sys:BadKey:-Unknown}");
        Assert.assertEquals((Object)"Unknown-${ctx:BadKey}-Unknown", (Object)value);
        value = subst.replace("${BadKey:-Unknown}-${ctx:BadKey:-}-${sys:BadKey:-Unknown}");
        Assert.assertEquals((Object)"Unknown--Unknown", (Object)value);
    }

    @Test
    public void testDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, TESTVAL);
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        ThreadContext.put((String)TESTKEY, (String)TESTVAL);
        String value = subst.replace("${sys:TestKey1:-${ctx:TestKey}}");
        Assert.assertEquals((Object)TESTVAL, (Object)value);
    }

    @Test
    public void testDefaultReferencesLookupValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(TESTKEY, "${java:version}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(false);
        String value = subst.replace("${sys:TestKey1:-${ctx:TestKey}}");
        Assert.assertEquals((Object)"${java:version}", (Object)value);
    }

    @Test
    public void testInfiniteSubstitutionOnString() {
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(new HashMap()));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        String infiniteSubstitution = "${${::-${::-$${::-j}}}}";
        Assert.assertEquals((Object)infiniteSubstitution, (Object)subst.replace(infiniteSubstitution));
    }

    @Test
    public void testInfiniteSubstitutionOnStringBuilder() {
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(new HashMap()));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        String infiniteSubstitution = "${${::-${::-$${::-j}}}}";
        Assert.assertEquals((Object)infiniteSubstitution, (Object)subst.replace(null, new StringBuilder(infiniteSubstitution)));
    }

    @Test
    public void testRecursiveSubstitution() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first}");
        map.put("second", "secondValue");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        Assert.assertEquals((Object)"${ctx:first} and secondValue", (Object)subst.replace("${ctx:first} and ${ctx:second}"));
    }

    @Test
    public void testRecursiveWithDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first:-default}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        Assert.assertEquals((Object)"default", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testRecursiveWithRecursiveDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${ctx:first:-${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        Assert.assertEquals((Object)"${ctx:first}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testNestedSelfReferenceWithRecursiveEvaluation() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        Assert.assertEquals((Object)"${${ctx:first}}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testRandomWithRecursiveDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${env:RANDOM:-${ctx:first}}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(true);
        Assert.assertEquals((Object)"${ctx:first}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testNoRecursiveEvaluationWithDefault() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${java:version}");
        map.put("second", "${java:runtime}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(false);
        Assert.assertEquals((Object)"${java:version}", (Object)subst.replace("${ctx:first:-${ctx:second}}"));
    }

    @Test
    public void testNoRecursiveEvaluationWithDepthOne() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "${java:version}");
        Interpolator lookup = new Interpolator((StrLookup)new MapLookup(map));
        StrSubstitutor subst = new StrSubstitutor((StrLookup)lookup);
        subst.setRecursiveEvaluationAllowed(false);
        Assert.assertEquals((Object)"${java:version}", (Object)subst.replace("${ctx:first}"));
    }

    @Test
    public void testLookupThrows() {
        StrSubstitutor subst = new StrSubstitutor((StrLookup)new Interpolator(new StrLookup(){

            public String lookup(String key) {
                if ("throw".equals(key)) {
                    throw new RuntimeException();
                }
                return "success";
            }

            public String lookup(LogEvent event, String key) {
                return this.lookup(key);
            }
        }));
        subst.setRecursiveEvaluationAllowed(false);
        Assert.assertEquals((Object)"success ${foo:throw} success", (Object)subst.replace("${foo:a} ${foo:throw} ${foo:c}"));
    }
}

