/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationAware;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.lookup.Log4jLookup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class Log4jLookupTest {
    private static final File EXPECT = new File(System.getProperty("user.home"), "/a/b/c/d/e/log4j2.xml");
    @Mock
    private LoggerContext mockCtx;
    @Mock
    private Configuration config;
    @Mock
    private ConfigurationSource configSrc;

    @Before
    public void setup() throws URISyntaxException {
        ContextAnchor.THREAD_CONTEXT.set(this.mockCtx);
        BDDMockito.given((Object)this.config.getConfigurationSource()).willReturn((Object)this.configSrc);
        BDDMockito.given((Object)this.configSrc.getFile()).willReturn((Object)EXPECT);
    }

    @After
    public void cleanup() {
        ContextAnchor.THREAD_CONTEXT.set(null);
    }

    @Test
    public void lookupConfigLocation() {
        Log4jLookup log4jLookup = new Log4jLookup();
        ((ConfigurationAware)log4jLookup).setConfiguration(this.config);
        String value = log4jLookup.lookup("configLocation");
        Assert.assertEquals((Object)EXPECT.getAbsolutePath(), (Object)value);
    }

    @Test
    public void lookupConfigParentLocation() {
        Log4jLookup log4jLookup = new Log4jLookup();
        ((ConfigurationAware)log4jLookup).setConfiguration(this.config);
        String value = log4jLookup.lookup("configParentLocation");
        Assert.assertEquals((Object)EXPECT.getParentFile().getAbsolutePath(), (Object)value);
    }
}

