/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAliases;
import org.apache.logging.log4j.core.config.plugins.processor.FakePlugin;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.core.config.plugins.processor.PluginProcessor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PluginProcessorTest {
    private static final PluginCache pluginCache = new PluginCache();
    private final Plugin p = FakePlugin.class.getAnnotation(Plugin.class);

    @BeforeClass
    public static void setUpClass() throws Exception {
        Enumeration<URL> resources = PluginProcessor.class.getClassLoader().getResources("META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
        pluginCache.loadCacheFiles(resources);
    }

    @Test
    public void testTestCategoryFound() throws Exception {
        Assert.assertNotNull((String)"No plugin annotation on FakePlugin.", (Object)this.p);
        Map testCategory = pluginCache.getCategory(this.p.category());
        Assert.assertNotEquals((String)"No plugins were found.", (long)0L, (long)pluginCache.size());
        Assert.assertNotNull((String)("The category '" + this.p.category() + "' was not found."), (Object)testCategory);
        Assert.assertFalse((boolean)testCategory.isEmpty());
    }

    @Test
    public void testFakePluginFoundWithCorrectInformation() throws Exception {
        PluginEntry fake = (PluginEntry)pluginCache.getCategory(this.p.category()).get(this.p.name().toLowerCase());
        this.verifyFakePluginEntry(this.p.name(), fake);
    }

    @Test
    public void testFakePluginAliasesContainSameInformation() throws Exception {
        PluginAliases aliases = FakePlugin.class.getAnnotation(PluginAliases.class);
        for (String alias : aliases.value()) {
            PluginEntry fake = (PluginEntry)pluginCache.getCategory(this.p.category()).get(alias.toLowerCase());
            this.verifyFakePluginEntry(alias, fake);
        }
    }

    private void verifyFakePluginEntry(String name, PluginEntry fake) {
        Assert.assertNotNull((String)("The plugin '" + name.toLowerCase() + "' was not found."), (Object)fake);
        Assert.assertEquals((Object)FakePlugin.class.getName(), (Object)fake.getClassName());
        Assert.assertEquals((Object)name.toLowerCase(), (Object)fake.getKey());
        Assert.assertEquals((Object)"", (Object)this.p.elementType());
        Assert.assertEquals((Object)name, (Object)fake.getName());
        Assert.assertEquals((Object)this.p.printObject(), (Object)fake.isPrintable());
        Assert.assertEquals((Object)this.p.deferChildren(), (Object)fake.isDefer());
    }

    @Test
    public void testNestedPlugin() throws Exception {
        Plugin p = FakePlugin.Nested.class.getAnnotation(Plugin.class);
        PluginEntry nested = (PluginEntry)pluginCache.getCategory(p.category()).get(p.name().toLowerCase());
        Assert.assertNotNull((Object)nested);
        Assert.assertEquals((Object)p.name().toLowerCase(), (Object)nested.getKey());
        Assert.assertEquals((Object)FakePlugin.Nested.class.getName(), (Object)nested.getClassName());
        Assert.assertEquals((Object)p.name(), (Object)nested.getName());
        Assert.assertEquals((Object)"", (Object)p.elementType());
        Assert.assertEquals((Object)p.printObject(), (Object)nested.isPrintable());
        Assert.assertEquals((Object)p.deferChildren(), (Object)nested.isDefer());
    }
}

