/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.File;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.AsyncLoggerConfig;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerConfigTest3 {
    @Test
    public void testNoConcurrentModificationException() throws Exception {
        System.setProperty("log4j.configurationFile", "AsyncLoggerConfigTest2.xml");
        File file = new File("target", "AsyncLoggerConfigTest2.log");
        Assert.assertTrue((String)"Deleted old file before test", (!file.exists() || file.delete() ? 1 : 0) != 0);
        Logger log = LogManager.getLogger((String)"com.foo.Bar");
        log.info("initial message");
        Thread.sleep(500L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int j = 0; j < 3000; ++j) {
            map.put(String.valueOf(j), String.valueOf(System.nanoTime()));
        }
        ParameterizedMessage msg = new ParameterizedMessage("{}", map);
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLevel(Level.WARN).setLoggerName(this.getClass().getName()).setMessage((Message)msg).setTimeMillis(0L).build();
        for (int i = 0; i < 100; ++i) {
            int j;
            ((AsyncLoggerConfig)((org.apache.logging.log4j.core.Logger)log).get()).callAppenders((LogEvent)event);
            for (j = 0; j < 3000; ++j) {
                map.remove(String.valueOf(j));
            }
            for (j = 0; j < 3000; ++j) {
                map.put(String.valueOf(j), String.valueOf(System.nanoTime()));
            }
        }
    }
}

