/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.LockSupport;
import org.apache.logging.log4j.core.appender.rolling.RollingRandomAccessFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.util.Closer;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.hamcrest.FileMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class RollingRandomAccessFileManagerTest {
    @Test
    public void testWrite_multiplesOfBufferSize() throws IOException {
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            boolean append = false;
            boolean flushNow = false;
            long triggerSize = Long.MAX_VALUE;
            long time = System.currentTimeMillis();
            SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy(Long.MAX_VALUE);
            RolloverStrategy rolloverStrategy = null;
            RollingRandomAccessFileManager manager = new RollingRandomAccessFileManager(null, raf, file.getName(), "", (OutputStream)os, false, false, 262144, Long.MAX_VALUE, time, (TriggeringPolicy)triggerPolicy, rolloverStrategy, null, null, null, null, null, true);
            int size = 786432;
            byte[] data = new byte[786432];
            manager.write(data, 0, data.length, false);
            Assert.assertEquals((long)786432L, (long)raf.length());
        }
    }

    @Test
    public void testWrite_dataExceedingBufferSize() throws IOException {
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            boolean append = false;
            boolean flushNow = false;
            long triggerSize = 0L;
            long time = System.currentTimeMillis();
            SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy(0L);
            RolloverStrategy rolloverStrategy = null;
            RollingRandomAccessFileManager manager = new RollingRandomAccessFileManager(null, raf, file.getName(), "", (OutputStream)os, false, false, 262144, 0L, time, (TriggeringPolicy)triggerPolicy, rolloverStrategy, null, null, null, null, null, true);
            int size = 786433;
            byte[] data = new byte[786433];
            manager.write(data, 0, data.length, false);
            Assert.assertEquals((long)786433L, (long)raf.length());
            manager.flush();
            Assert.assertEquals((long)786433L, (long)raf.length());
        }
    }

    @Test
    public void testConfigurableBufferSize() throws IOException {
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            boolean append = false;
            boolean flushNow = false;
            long triggerSize = 0L;
            long time = System.currentTimeMillis();
            SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy(0L);
            int bufferSize = 4096;
            Assert.assertNotEquals((long)4096L, (long)262144L);
            RolloverStrategy rolloverStrategy = null;
            RollingRandomAccessFileManager manager = new RollingRandomAccessFileManager(null, raf, file.getName(), "", (OutputStream)os, false, false, 4096, 0L, time, (TriggeringPolicy)triggerPolicy, rolloverStrategy, null, null, null, null, null, true);
            Assert.assertEquals((long)4096L, (long)manager.getBufferSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendDoesNotOverwriteExistingFile() throws IOException {
        boolean isAppend = true;
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        Assert.assertThat((Object)file, FileMatchers.isEmpty());
        byte[] bytes = new byte[4096];
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bytes, 0, bytes.length);
            fos.flush();
        }
        catch (Throwable throwable) {
            Closer.closeSilently(fos);
            throw throwable;
        }
        Closer.closeSilently((AutoCloseable)fos);
        Assert.assertThat((String)"all flushed to disk", (Object)file, FileMatchers.hasLength(bytes.length));
        boolean immediateFlush = true;
        RollingRandomAccessFileManager manager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager((String)file.getAbsolutePath(), (String)"", (boolean)true, (boolean)true, (int)262144, (TriggeringPolicy)new SizeBasedTriggeringPolicy(Long.MAX_VALUE), null, null, null, null, null, null, null);
        manager.write(bytes, 0, bytes.length, true);
        int expected = bytes.length * 2;
        Assert.assertThat((String)"appended, not overwritten", (Object)file, FileMatchers.hasLength(expected));
    }

    @Test
    public void testFileTimeBasedOnSystemClockWhenAppendIsFalse() throws IOException {
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        LockSupport.parkNanos(1000000L);
        boolean isAppend = false;
        long expectedMin = System.currentTimeMillis();
        long expectedMax = expectedMin + 500L;
        Assert.assertThat((Object)file, FileMatchers.lastModified((Matcher<Long>)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(expectedMin))));
        RollingRandomAccessFileManager manager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager((String)file.getAbsolutePath(), (String)"", (boolean)false, (boolean)true, (int)262144, (TriggeringPolicy)new SizeBasedTriggeringPolicy(Long.MAX_VALUE), null, null, null, null, null, null, null);
        Assert.assertTrue((manager.getFileTime() < expectedMax ? 1 : 0) != 0);
        Assert.assertTrue((manager.getFileTime() >= expectedMin ? 1 : 0) != 0);
    }

    @Test
    public void testFileTimeBasedOnFileModifiedTimeWhenAppendIsTrue() throws IOException {
        File file = File.createTempFile("log4j2", "test");
        file.deleteOnExit();
        LockSupport.parkNanos(1000000L);
        boolean isAppend = true;
        Assert.assertThat((Object)file, FileMatchers.lastModified(FileMatchers.beforeNow()));
        RollingRandomAccessFileManager manager = RollingRandomAccessFileManager.getRollingRandomAccessFileManager((String)file.getAbsolutePath(), (String)"", (boolean)true, (boolean)true, (int)262144, (TriggeringPolicy)new SizeBasedTriggeringPolicy(Long.MAX_VALUE), null, null, null, null, null, null, null);
        Assert.assertThat((Object)file, FileMatchers.lastModified((Matcher<Long>)Matchers.equalTo((Object)manager.getFileTime())));
    }
}

