/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.appender.SocketAppenderTest;
import org.apache.logging.log4j.core.net.Rfc1349TrafficClass;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.AvailablePortFinder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;

public class SocketAppenderSocketOptionsTest {
    private static final int PORT = AvailablePortFinder.getNextAvailable();
    private static SocketAppenderTest.TcpSocketTestServer tcpSocketTestServer;
    @ClassRule
    public static final LoggerContextRule loggerContextRule;

    @AfterClass
    public static void afterClass() {
        if (tcpSocketTestServer != null) {
            tcpSocketTestServer.shutdown();
        }
    }

    @Test
    public void testSocketOptions() throws IOException {
        Assert.assertNotNull((Object)loggerContextRule);
        Assert.assertNotNull((Object)loggerContextRule.getConfiguration());
        SocketAppender appender = loggerContextRule.getAppender("socket", SocketAppender.class);
        Assert.assertNotNull((Object)appender);
        TcpSocketManager manager = (TcpSocketManager)appender.getManager();
        Assert.assertNotNull((Object)manager);
        OutputStream outputStream = manager.getOutputStream();
        Assert.assertFalse((boolean)(outputStream instanceof NullOutputStream));
        SocketOptions socketOptions = manager.getSocketOptions();
        Assert.assertNotNull((Object)socketOptions);
        Socket socket = manager.getSocket();
        Assert.assertNotNull((Object)socket);
        Assert.assertEquals((Object)false, (Object)socketOptions.isKeepAlive());
        Assert.assertEquals((Object)false, (Object)socketOptions.isOobInline());
        Assert.assertEquals((Object)false, (Object)socketOptions.isReuseAddress());
        Assert.assertEquals((Object)false, (Object)socketOptions.isTcpNoDelay());
        Assert.assertEquals((long)Rfc1349TrafficClass.IPTOS_LOWCOST.value(), (long)socketOptions.getActualTrafficClass().intValue());
        Assert.assertEquals((long)10000L, (long)socketOptions.getReceiveBufferSize().intValue());
        Assert.assertEquals((long)8000L, (long)socketOptions.getSendBufferSize().intValue());
        Assert.assertEquals((long)12345L, (long)socketOptions.getSoLinger().intValue());
        Assert.assertEquals((long)54321L, (long)socketOptions.getSoTimeout().intValue());
        Assert.assertEquals((Object)false, (Object)socket.getKeepAlive());
        Assert.assertEquals((Object)false, (Object)socket.getOOBInline());
        Assert.assertEquals((Object)false, (Object)socket.getReuseAddress());
        Assert.assertEquals((Object)false, (Object)socket.getTcpNoDelay());
        Assert.assertEquals((long)12345L, (long)socket.getSoLinger());
        Assert.assertEquals((long)54321L, (long)socket.getSoTimeout());
    }

    @Test
    public void testSocketTrafficClass() throws IOException {
        Assume.assumeTrue((String)"Run only on Java 7", (boolean)System.getProperty("java.specification.version").equals("1.7"));
        Assume.assumeFalse((String)"Do not run on Travis CI", (boolean)"true".equals(System.getenv("TRAVIS")));
        SocketAppender appender = loggerContextRule.getAppender("socket", SocketAppender.class);
        TcpSocketManager manager = (TcpSocketManager)appender.getManager();
        Socket socket = manager.getSocket();
        Assert.assertEquals((long)Rfc1349TrafficClass.IPTOS_LOWCOST.value(), (long)socket.getTrafficClass());
    }

    static {
        System.setProperty("SocketAppenderSocketOptionsTest.port", Integer.toString(PORT));
        try {
            tcpSocketTestServer = new SocketAppenderTest.TcpSocketTestServer(PORT);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        tcpSocketTestServer.start();
        loggerContextRule = new LoggerContextRule("log4j-socket-options.xml");
    }
}

