/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.logging.log4j.core.appender.RandomAccessFileManager;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RandomAccessFileManagerTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testWrite_multiplesOfBufferSize() throws IOException {
        File file = folder.newFile();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 262144, null, null, true);
            int size = 786432;
            byte[] data = new byte[786432];
            manager.write(data);
            Assert.assertEquals((long)786432L, (long)raf.length());
        }
    }

    @Test
    public void testWrite_dataExceedingBufferSize() throws IOException {
        File file = folder.newFile();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 262144, null, null, true);
            int size = 786433;
            byte[] data = new byte[786433];
            manager.write(data);
            Assert.assertEquals((long)786433L, (long)raf.length());
            manager.flush();
            Assert.assertEquals((long)786433L, (long)raf.length());
        }
    }

    @Test
    public void testConfigurableBufferSize() throws IOException {
        File file = folder.newFile();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            int bufferSize = 4096;
            Assert.assertNotEquals((long)4096L, (long)262144L);
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 4096, null, null, true);
            Assert.assertEquals((long)4096L, (long)manager.getBufferSize());
        }
    }

    @Test
    public void testWrite_dataExceedingMinBufferSize() throws IOException {
        File file = folder.newFile();
        try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            NullOutputStream os = NullOutputStream.getInstance();
            boolean bufferSize = true;
            RandomAccessFileManager manager = new RandomAccessFileManager(null, raf, file.getName(), (OutputStream)os, 1, null, null, true);
            int size = 4;
            byte[] data = new byte[4];
            manager.write(data);
            Assert.assertEquals((long)4L, (long)raf.length());
            manager.flush();
            Assert.assertEquals((long)4L, (long)raf.length());
        }
    }

    @Test
    public void testAppendDoesNotOverwriteExistingFile() throws IOException {
        boolean isAppend = true;
        File file = folder.newFile();
        Assert.assertEquals((long)0L, (long)file.length());
        byte[] bytes = new byte[4096];
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(bytes, 0, bytes.length);
            fos.flush();
        }
        Assert.assertEquals((String)"all flushed to disk", (long)bytes.length, (long)file.length());
        RandomAccessFileManager manager = RandomAccessFileManager.getFileManager((String)file.getAbsolutePath(), (boolean)true, (boolean)true, (int)262144, null, null, null);
        manager.write(bytes, 0, bytes.length, true);
        int expected = bytes.length * 2;
        Assert.assertEquals((String)"appended, not overwritten", (long)expected, (long)file.length());
    }
}

