/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.FilteredObjectInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LogEventTest {
    private static Message MESSAGE = new SimpleMessage("This is a test");
    private static TestClass TESTER = new TestClass();

    @Test
    public void testSerialization() throws Exception {
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        IllegalStateException parent = new IllegalStateException("Test");
        LoggingException child = new LoggingException("This is a test", (Throwable)parent);
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).setThrown((Throwable)child).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(event1);
        oos.writeObject(event2);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        FilteredObjectInputStream ois = new FilteredObjectInputStream((InputStream)bais);
        try {
            ois.readObject();
        }
        catch (IOException ioe) {
            Assert.fail((String)"Exception processing event1");
        }
        try {
            ois.readObject();
        }
        catch (IOException ioe) {
            Assert.fail((String)"Exception processing event2");
        }
    }

    @Test
    public void testNanoTimeIsNotSerialized1() throws Exception {
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).setThreadName("this must be initialized or the test fails").setNanoTime(12345678L).build();
        Log4jLogEvent copy = new Log4jLogEvent.Builder((LogEvent)event1).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(event1);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        FilteredObjectInputStream ois = new FilteredObjectInputStream((InputStream)bais);
        LogEvent actual = (LogEvent)ois.readObject();
        Assert.assertNotEquals((String)"Different event: nanoTime", (Object)copy, (Object)actual);
        Assert.assertNotEquals((String)"Different nanoTime", (long)copy.getNanoTime(), (long)actual.getNanoTime());
        Assert.assertEquals((String)"deserialized nanoTime is zero", (long)0L, (long)actual.getNanoTime());
    }

    @Test
    public void testNanoTimeIsNotSerialized2() throws Exception {
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).setThreadId(1L).setThreadName("this must be initialized or the test fails").setThreadPriority(2).setNanoTime(0L).build();
        Log4jLogEvent event2 = new Log4jLogEvent.Builder((LogEvent)event1).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(event1);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        FilteredObjectInputStream ois = new FilteredObjectInputStream((InputStream)bais);
        LogEvent actual = (LogEvent)ois.readObject();
        Assert.assertEquals((String)"both zero nanoTime", (Object)event2, (Object)actual);
    }

    @Test
    @Ignore
    public void testEquals() {
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Log4jLogEvent event3 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        Assert.assertNotEquals((String)"Events should not be equal", (Object)event1, (Object)event2);
        Assert.assertEquals((String)"Events should be equal", (Object)event2, (Object)event3);
    }

    @Test
    public void testLocation() {
        StackTraceElement ste = TESTER.getEventSource(this.getClass().getName());
        Assert.assertNotNull((String)"No StackTraceElement", (Object)ste);
        Assert.assertEquals((String)"Incorrect event", (Object)this.getClass().getName(), (Object)ste.getClassName());
    }

    private static class TestClass {
        private static final String FQCN = TestClass.class.getName();

        private TestClass() {
        }

        public StackTraceElement getEventSource(String loggerName) {
            Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(loggerName).setLoggerFqcn(FQCN).setLevel(Level.INFO).setMessage(MESSAGE).build();
            event.setIncludeLocation(true);
            return event.getSource();
        }
    }
}

