/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.EqualsIgnoreCaseReplacementConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.junit.Assert;
import org.junit.Test;

public class EqualsIgnoreCaseReplacementConverterTest {
    @Test
    public void testMarkerReplacement() {
        this.testReplacement("%marker", "");
    }

    @Test
    public void testMarkerSimpleNameReplacement() {
        this.testReplacement("%markerSimpleName", "");
    }

    @Test
    public void testLoggerNameReplacement() {
        this.testReplacement("%logger", "aaa[" + EqualsIgnoreCaseReplacementConverterTest.class.getName() + "]zzz");
    }

    private void testReplacement(String tag, String expectedValue) {
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(EqualsIgnoreCaseReplacementConverterTest.class.getName()).setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("This is a test")).build();
        StringBuilder sb = new StringBuilder();
        LoggerContext ctx = LoggerContext.getContext();
        String[] options = new String[]{"aaa[" + tag + "]zzz", "AAA[]ZZZ", expectedValue};
        EqualsIgnoreCaseReplacementConverter converter = EqualsIgnoreCaseReplacementConverter.newInstance((Configuration)ctx.getConfiguration(), (String[])options);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)expectedValue, (Object)sb.toString());
    }
}

