/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class PluginManagerPackagesTest {
    private static Configuration config;
    private static ListAppender listAppender;
    private static LoggerContext ctx;

    @AfterClass
    public static void cleanupClass() {
        System.clearProperty("log4j.configurationFile");
        ctx.reconfigure();
        StatusLogger.getLogger().reset();
    }

    @Test
    public void test() throws Exception {
        File orig = new File("target/test-classes/customplugin/FixedStringLayout.java.source");
        File f = new File(orig.getParentFile(), "FixedStringLayout.java");
        Assert.assertTrue((String)"renamed source file OK", (boolean)orig.renameTo(f));
        PluginManagerPackagesTest.compile(f);
        Assert.assertTrue((String)"reverted source file OK", (boolean)f.renameTo(orig));
        Class.forName("customplugin.FixedStringLayout");
        ctx = Configurator.initialize((String)"Test1", (String)"customplugin/log4j2-741.xml");
        config = ctx.getConfiguration();
        listAppender = (ListAppender)config.getAppender("List");
        Logger logger = LogManager.getLogger(PluginManagerPackagesTest.class);
        logger.info("this message is ignored");
        List<String> messages = listAppender.getMessages();
        Assert.assertEquals((String)messages.toString(), (long)1L, (long)messages.size());
        Assert.assertEquals((Object)"abc123XYZ", (Object)messages.get(0));
    }

    static void compile(File f) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ArrayList<String> errors = new ArrayList<String>();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);){
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(f));
            List<String> options = Arrays.asList("-proc:none");
            compiler.getTask(null, fileManager, diagnostics, options, null, compilationUnits).call();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
                errors.add(String.format("Compile error: %s%n", diagnostic.getMessage(Locale.getDefault())));
            }
        }
        Assert.assertTrue((String)((Object)errors).toString(), (boolean)errors.isEmpty());
    }
}

