/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.impl.LocationAwareLogEventFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LogEventFactoryTest {
    private static final String CONFIG = "log4j2-config.xml";
    private static final LoggerContextRule context = new LoggerContextRule("log4j2-config.xml");
    private ListAppender app;
    @ClassRule
    public static RuleChain chain = RuleChain.outerRule((TestRule)new TestRule(){

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    System.setProperty("Log4jLogEventFactory", TestLogEventFactory.class.getName());
                    this.resetLogEventFactory(new TestLogEventFactory());
                    try {
                        base.evaluate();
                    }
                    finally {
                        System.clearProperty("Log4jLogEventFactory");
                        this.resetLogEventFactory((LogEventFactory)new DefaultLogEventFactory());
                    }
                }

                private void resetLogEventFactory(LogEventFactory logEventFactory) throws IllegalAccessException {
                    Field field = FieldUtils.getField(LoggerConfig.class, (String)"LOG_EVENT_FACTORY", (boolean)true);
                    FieldUtils.removeFinalModifier((Field)field, (boolean)true);
                    FieldUtils.writeStaticField((Field)field, (Object)logEventFactory, (boolean)false);
                }
            };
        }
    }).around((TestRule)context);

    @Before
    public void before() {
        this.app = context.getListAppender("List").clear();
    }

    @Test
    public void testEvent() {
        Logger logger = context.getLogger("org.apache.test.LogEventFactory");
        logger.error("error message");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertNotNull((String)"No events", events);
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
        LogEvent event = events.get(0);
        Assert.assertEquals((String)"TestLogEventFactory wasn't used", (Object)"Test", (Object)event.getLoggerName());
    }

    public static class TestLogEventFactory
    implements LogEventFactory,
    LocationAwareLogEventFactory {
        public LogEvent createEvent(String loggerName, Marker marker, String fqcn, Level level, Message data, List<Property> properties, Throwable t) {
            return new Log4jLogEvent("Test", marker, fqcn, level, data, properties, t);
        }

        public LogEvent createEvent(String loggerName, Marker marker, String fqcn, StackTraceElement location, Level level, Message data, List<Property> properties, Throwable t) {
            return new Log4jLogEvent("Test", marker, fqcn, level, data, properties, t);
        }
    }
}

