/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.async.QueueFullAbstractTest;
import org.apache.logging.log4j.core.async.QueueFullAsyncLoggerTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class QueueFullAsyncLoggerTest2
extends QueueFullAbstractTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-queueFull.xml", AsyncLoggerContextSelector.class);

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.format.msg.async", "true");
        System.setProperty("AsyncLogger.RingBufferSize", "128");
        System.setProperty("log4j.configurationFile", "log4j2-queueFull.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Before
    public void before() throws Exception {
        this.blockingAppender = this.context.getRequiredAppender("Blocking", BlockingAppender.class);
    }

    @Test(timeout=5000L)
    public void testNormalQueueFullKeepsMessagesInOrder() throws InterruptedException {
        Logger logger = LogManager.getLogger(this.getClass());
        this.blockingAppender.countDownLatch = new CountDownLatch(1);
        this.unlocker = new QueueFullAbstractTest.Unlocker(this, new CountDownLatch(129));
        this.unlocker.start();
        QueueFullAsyncLoggerTest.asyncLoggerTest(logger, this.unlocker, this.blockingAppender);
    }
}

