/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.kafka;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaManager;
import org.apache.logging.log4j.core.appender.mom.kafka.KafkaProducerFactory;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Appenders.Kafka.class})
public class KafkaAppenderCloseTimeoutTest {
    private static final MockProducer<byte[], byte[]> kafka = new MockProducer<byte[], byte[]>(true, null, null){

        public void close() {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void close(long timeout, TimeUnit timeUnit) {
            try {
                Thread.sleep(timeUnit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    @Rule
    public LoggerContextRule ctx = new LoggerContextRule("KafkaAppenderCloseTimeoutTest.xml");

    @BeforeClass
    public static void setUpClass() throws Exception {
        KafkaManager.producerFactory = new KafkaProducerFactory(){

            public Producer<byte[], byte[]> newKafkaProducer(Properties config) {
                return kafka;
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        kafka.clear();
    }

    @Test(timeout=2000L)
    public void testClose() throws Exception {
        Appender appender = this.ctx.getRequiredAppender("KafkaAppender");
        appender.stop();
    }
}

