/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.jeromq;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.categories.Appenders;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.mom.jeromq.JeroMqAppender;
import org.apache.logging.log4j.core.appender.mom.jeromq.JeroMqManager;
import org.apache.logging.log4j.core.appender.mom.jeromq.JeroMqTestClient;
import org.apache.logging.log4j.core.util.ExecutorServices;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Appenders.ZeroMq.class})
public class JeroMqAppenderTest {
    private static final String ENDPOINT = "tcp://localhost:5556";
    private static final String APPENDER_NAME = "JeroMQAppender";
    private static final int DEFAULT_TIMEOUT_MILLIS = 60000;
    @ClassRule
    public static LoggerContextRule ctx = new LoggerContextRule("JeroMqAppenderTest.xml");

    @Test(timeout=60000L)
    public void testAppenderLifeCycle() throws Exception {
        Assert.assertNotNull((Object)JeroMqManager.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testClientServer() throws Exception {
        JeroMqAppender appender = ctx.getRequiredAppender(APPENDER_NAME, JeroMqAppender.class);
        int expectedReceiveCount = 3;
        JeroMqTestClient client = new JeroMqTestClient(JeroMqManager.getContext(), ENDPOINT, 3);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<List<String>> future = executor.submit(client);
            Thread.sleep(100L);
            Logger logger = ctx.getLogger(this.getClass().getName());
            appender.resetSendRcs();
            logger.info("Hello");
            logger.info("Again");
            ThreadContext.put((String)"foo", (String)"bar");
            logger.info("World");
            List<String> list = future.get();
            Assert.assertEquals((long)3L, (long)appender.getSendRcTrue());
            Assert.assertEquals((long)0L, (long)appender.getSendRcFalse());
            Assert.assertEquals((Object)"Hello", (Object)list.get(0));
            Assert.assertEquals((Object)"Again", (Object)list.get(1));
            Assert.assertEquals((Object)"barWorld", (Object)list.get(2));
        }
        finally {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testMultiThreadedServer() throws Exception {
        int nThreads = 10;
        JeroMqAppender appender = ctx.getRequiredAppender(APPENDER_NAME, JeroMqAppender.class);
        int expectedReceiveCount = 20;
        JeroMqTestClient client = new JeroMqTestClient(JeroMqManager.getContext(), ENDPOINT, 20);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<List<String>> future = executor.submit(client);
            Thread.sleep(100L);
            final Logger logger = ctx.getLogger(this.getClass().getName());
            appender.resetSendRcs();
            ExecutorService fixedThreadPool = Executors.newFixedThreadPool(10);
            int i = 0;
            while ((double)i < 10.0) {
                fixedThreadPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Hello");
                        logger.info("Again");
                    }
                });
                ++i;
            }
            List<String> list = future.get();
            Assert.assertEquals((long)20L, (long)appender.getSendRcTrue());
            Assert.assertEquals((long)0L, (long)appender.getSendRcFalse());
            int hello = 0;
            int again = 0;
            Iterator<String> iterator = list.iterator();
            block12: while (iterator.hasNext()) {
                String string;
                switch (string = iterator.next()) {
                    case "Hello": {
                        ++hello;
                        continue block12;
                    }
                    case "Again": {
                        ++again;
                        continue block12;
                    }
                }
                Assert.fail((String)("Unexpected message: " + string));
            }
            Assert.assertEquals((long)10L, (long)hello);
            Assert.assertEquals((long)10L, (long)again);
        }
        finally {
            ExecutorServices.shutdown((ExecutorService)executor, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)JeroMqAppenderTest.class.getSimpleName());
        }
    }

    @Test(timeout=60000L)
    public void testServerOnly() throws Exception {
        Logger logger = ctx.getLogger(this.getClass().getName());
        JeroMqAppender appender = ctx.getRequiredAppender(APPENDER_NAME, JeroMqAppender.class);
        appender.resetSendRcs();
        logger.info("Hello");
        logger.info("Again");
        Assert.assertEquals((long)2L, (long)appender.getSendRcTrue());
        Assert.assertEquals((long)0L, (long)appender.getSendRcFalse());
    }
}

