/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class WatchManagerTest {
    private static final String FORCE_RUN_KEY = WatchManagerTest.class.getSimpleName() + ".forceRun";
    private final String testFile = "target/testWatchFile";
    private final String originalFile = "target/test-classes/log4j-test1.xml";
    private final String newFile = "target/test-classes/log4j-test1.yaml";
    private static final boolean IS_WINDOWS = PropertiesUtil.getProperties().isOsWindows();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManager() throws Exception {
        Assume.assumeTrue((!IS_WINDOWS || Boolean.getBoolean(FORCE_RUN_KEY) ? 1 : 0) != 0);
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assert.assertNotNull((String)"File change not detected", (Object)f);
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManagerReset() throws Exception {
        Assume.assumeTrue((!IS_WINDOWS || Boolean.getBoolean(FORCE_RUN_KEY) ? 1 : 0) != 0);
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            watchManager.stop();
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            watchManager.reset();
            watchManager.start();
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assert.assertNull((String)"File change detected", (Object)f);
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatchManagerResetFile() throws Exception {
        Assume.assumeTrue((!IS_WINDOWS || Boolean.getBoolean(FORCE_RUN_KEY) ? 1 : 0) != 0);
        ConfigurationScheduler scheduler = new ConfigurationScheduler();
        scheduler.incrementScheduledItems();
        WatchManager watchManager = new WatchManager(scheduler);
        watchManager.setIntervalSeconds(1);
        scheduler.start();
        watchManager.start();
        try {
            File sourceFile = new File("target/test-classes/log4j-test1.xml");
            Path source = Paths.get(sourceFile.toURI());
            try (FileOutputStream targetStream = new FileOutputStream("target/testWatchFile");){
                Files.copy(source, targetStream);
            }
            File updateFile = new File("target/test-classes/log4j-test1.yaml");
            File targetFile = new File("target/testWatchFile");
            LinkedBlockingQueue<File> queue = new LinkedBlockingQueue<File>();
            watchManager.watchFile(targetFile, (FileWatcher)new TestWatcher(queue));
            watchManager.stop();
            Thread.sleep(1000L);
            source = Paths.get(updateFile.toURI());
            Files.copy(source, Paths.get(targetFile.toURI()), StandardCopyOption.REPLACE_EXISTING);
            watchManager.reset(targetFile);
            watchManager.start();
            Thread.sleep(1000L);
            File f = (File)queue.poll(1L, TimeUnit.SECONDS);
            Assert.assertNull((String)"File change detected", (Object)f);
        }
        finally {
            watchManager.stop();
            scheduler.stop();
        }
    }

    private class TestWatcher
    implements FileWatcher {
        private final Queue<File> queue;

        public TestWatcher(Queue<File> queue) {
            this.queue = queue;
        }

        public void fileModified(File file) {
            System.out.println(file.toString() + " was modified");
            this.queue.add(file);
        }
    }
}

