/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class NestedLoggingFromThrowableMessageTest {
    private static File file1 = new File("target/NestedLoggerTest1.log");
    private static File file2 = new File("target/NestedLoggerTest2.log");
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j-nested-logging-throwable-message.xml");
    private Logger logger;

    @BeforeClass
    public static void beforeClass() {
        file1.delete();
        file2.delete();
        System.setProperty("log4j2.is.webapp", "false");
    }

    @Before
    public void before() {
        this.logger = LogManager.getLogger(NestedLoggingFromThrowableMessageTest.class);
    }

    @Test
    public void testNestedLoggingInLastArgument() throws Exception {
        this.logger.error("Test", (Throwable)new ThrowableLogsInGetMessage());
        CoreLoggerContexts.stopLoggerContext(false, file1);
        CoreLoggerContexts.stopLoggerContext(false, file2);
        Set<String> lines1 = NestedLoggingFromThrowableMessageTest.readUniqueLines(file1);
        Set<String> lines2 = NestedLoggingFromThrowableMessageTest.readUniqueLines(file2);
        Assert.assertEquals((String)"Expected the same data from both appenders", lines1, lines2);
        Assert.assertEquals((long)2L, (long)lines1.size());
        Assert.assertTrue((boolean)lines1.contains("INFO NestedLoggingFromThrowableMessageTest Logging in getMessage "));
        Assert.assertTrue((boolean)lines1.contains("ERROR NestedLoggingFromThrowableMessageTest Test message"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readUniqueLines(File input) throws IOException {
        HashSet<String> lines = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(input)));){
            String line;
            while ((line = reader.readLine()) != null) {
                Assert.assertTrue((String)("Read duplicate line: " + line), (boolean)lines.add(line));
            }
        }
        return lines;
    }

    class ThrowableLogsInGetMessage
    extends RuntimeException {
        ThrowableLogsInGetMessage() {
        }

        @Override
        public String getMessage() {
            NestedLoggingFromThrowableMessageTest.this.logger.info("Logging in getMessage");
            return "message";
        }
    }
}

