/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.text.DecimalFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

public class ProgressConsoleTest {
    private static final Logger LOG = LogManager.getLogger(ProgressConsoleTest.class);

    public static void main(String[] args) {
        try (LoggerContext ctx = Configurator.initialize((String)ProgressConsoleTest.class.getName(), (String)"target/test-classes/log4j2-progress-console.xml");){
            for (double i = 0.0; i <= 1.0; i += 0.05) {
                ProgressConsoleTest.updateProgress(i);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void updateProgress(double progressPercentage) {
        int i;
        int width = 50;
        String s = "[";
        for (i = 0; i <= (int)(progressPercentage * 50.0); ++i) {
            s = s + ".";
        }
        while (i < 50) {
            s = s + " ";
            ++i;
        }
        s = s + "](" + new DecimalFormat("#0.00").format(progressPercentage * 100.0) + "%)";
        LOG.info(s);
    }
}

