/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.FailOnceAppender;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class FailoverAppenderTest {
    private ListAppender app;
    private FailOnceAppender foApp;
    private Logger logger;
    private Logger onceLogger;
    @ClassRule
    public static LoggerContextRule init = new LoggerContextRule("log4j-failover.xml");

    @Before
    public void setUp() throws Exception {
        this.app = init.getListAppender("List");
        this.foApp = (FailOnceAppender)((Object)init.getAppender("Once"));
        this.logger = init.getLogger("LoggerTest");
        this.onceLogger = init.getLogger("Once");
    }

    @After
    public void tearDown() throws Exception {
        if (this.app != null) {
            this.app.clear();
        }
    }

    @Test
    public void testFailover() {
        this.logger.error("This is a test");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertNotNull(events);
        Assert.assertEquals((String)("Incorrect number of events. Should be 1 is " + events.size()), (long)events.size(), (long)1L);
        this.app.clear();
        this.logger.error("This is a test");
        events = this.app.getEvents();
        Assert.assertNotNull(events);
        Assert.assertEquals((String)("Incorrect number of events. Should be 1 is " + events.size()), (long)events.size(), (long)1L);
    }

    @Test
    public void testRecovery() throws Exception {
        this.onceLogger.error("Fail once");
        this.onceLogger.error("Fail again");
        List<LogEvent> events = this.app.getEvents();
        Assert.assertNotNull(events);
        Assert.assertEquals((String)("Incorrect number of events. Should be 2 is " + events.size()), (long)events.size(), (long)2L);
        this.app.clear();
        Thread.sleep(1100L);
        this.onceLogger.error("Fail after recovery interval");
        this.onceLogger.error("Second log message");
        events = this.app.getEvents();
        Assert.assertEquals((String)"Did not recover", (long)events.size(), (long)0L);
        events = this.foApp.getEvents();
        Assert.assertEquals((String)"Incorrect number of events in primary appender", (long)events.size(), (long)2L);
    }
}

