/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class LoggerUpdateTest {
    private static final String CONFIG = "log4j-test2.xml";
    private ListAppender app;
    @ClassRule
    public static LoggerContextRule context = new LoggerContextRule("log4j-test2.xml");

    @Before
    public void before() {
        this.app = context.getListAppender("List").clear();
    }

    @Test
    public void resetLevel() {
        Logger logger = context.getLogger("com.apache.test");
        logger.traceEntry();
        List<LogEvent> events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 1, actual " + events.size()), (long)1L, (long)events.size());
        this.app.clear();
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(Level.DEBUG);
        ctx.updateLoggers();
        logger.traceEntry();
        events = this.app.getEvents();
        Assert.assertEquals((String)("Incorrect number of events. Expected 0, actual " + events.size()), (long)0L, (long)events.size());
    }

    @Test
    public void testUpdateLoggersPropertyListeners() throws Exception {
        final LoggerContext ctx = context.getLoggerContext();
        ctx.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Assert.assertEquals((Object)"config", (Object)evt.getPropertyName());
                Assert.assertSame((Object)ctx, (Object)evt.getSource());
            }
        });
        ctx.updateLoggers();
    }
}

