/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.core.util.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileUtilsTest {
    private static final String LOG4J_CONFIG_WITH_PLUS = "log4j+config+with+plus+characters.xml";

    @Test
    public void testFileFromUriWithPlusCharactersInName() throws Exception {
        String config = "target/test-classes/log4j+config+with+plus+characters.xml";
        URI uri = new URI("target/test-classes/log4j+config+with+plus+characters.xml");
        File file = FileUtils.fileFromUri((URI)uri);
        Assert.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assert.assertTrue((String)"file exists", (boolean)file.exists());
    }

    @Test
    public void testFileFromUriWithSpacesAndPlusCharactersInName() throws Exception {
        String config = "target/test-classes/s%20p%20a%20c%20e%20s/log4j%2Bconfig%2Bwith%2Bplus%2Bcharacters.xml";
        URI uri = new URI("target/test-classes/s%20p%20a%20c%20e%20s/log4j%2Bconfig%2Bwith%2Bplus%2Bcharacters.xml");
        File file = FileUtils.fileFromUri((URI)uri);
        Assert.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assert.assertTrue((String)"file exists", (boolean)file.exists());
    }

    @Test
    public void testFileExistsWithPlusCharactersInName() throws Exception {
        String config = "target/test-classes/log4j+config+with+plus+characters.xml";
        File file = new File("target/test-classes/log4j+config+with+plus+characters.xml");
        Assert.assertEquals((Object)LOG4J_CONFIG_WITH_PLUS, (Object)file.getName());
        Assert.assertTrue((String)"file exists", (boolean)file.exists());
        URI uri1 = new URI("target/test-classes/log4j+config+with+plus+characters.xml");
        Assert.assertNull((Object)uri1.getScheme());
        URI uri2 = new File(uri1.getPath()).toURI();
        Assert.assertNotNull((Object)uri2);
        Assert.assertTrue((String)("URI \"" + uri2 + "\" does not end with \"" + LOG4J_CONFIG_WITH_PLUS + "\""), (boolean)uri2.toString().endsWith(LOG4J_CONFIG_WITH_PLUS));
        String fileName = uri2.toURL().getFile();
        Assert.assertTrue((String)("File name \"" + fileName + "\" does not end with \"" + LOG4J_CONFIG_WITH_PLUS + "\""), (boolean)fileName.endsWith(LOG4J_CONFIG_WITH_PLUS));
    }

    @Test
    public void testFileFromUriWithPlusCharactersConvertedToSpacesIfFileDoesNotExist() throws Exception {
        String config = "NON-EXISTING-PATH/this+file+does+not+exist.xml";
        URI uri = new URI("NON-EXISTING-PATH/this+file+does+not+exist.xml");
        File file = FileUtils.fileFromUri((URI)uri);
        Assert.assertEquals((Object)"this file does not exist.xml", (Object)file.getName());
        Assert.assertFalse((String)"file does not exist", (boolean)file.exists());
    }
}

