/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.pattern.MarkerSimpleNamePatternConverter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.junit.Assert;
import org.junit.Test;

public class MarkerSimpleNamePatternConverterTest {
    @Test
    public void testLookup() {
        StructuredDataMessage msg = new StructuredDataMessage("Test", "This is a test", "Audit");
        Marker eventMarker = MarkerManager.getMarker((String)"EVENT");
        Marker auditMarker = MarkerManager.getMarker((String)"AUDIT").setParents(new Marker[]{eventMarker});
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName("MyLogger").setMarker(auditMarker).setLevel(Level.DEBUG).setMessage((Message)msg).build();
        StringBuilder sb = new StringBuilder();
        MarkerSimpleNamePatternConverter converter = MarkerSimpleNamePatternConverter.newInstance(null);
        converter.format((LogEvent)event, sb);
        Assert.assertEquals((Object)auditMarker.getName(), (Object)sb.toString());
    }
}

