/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.BasicConfigurationFactory;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.MarkerPatternSelector;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.lookup.MainMapLookup;
import org.apache.logging.log4j.junit.ThreadContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.Strings;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class PatternLayoutTest {
    static ConfigurationFactory cf = new BasicConfigurationFactory();
    static String msgPattern = "%m%n";
    static String OUTPUT_FILE = "target/output/PatternParser";
    static final String regexPattern = "%replace{%logger %msg}{\\.}{/}";
    static String WITNESS_FILE = "witness/PatternParser";
    LoggerContext ctx = LoggerContext.getContext();
    Logger root = this.ctx.getRootLogger();
    @Rule
    public final ThreadContextRule threadContextRule = new ThreadContextRule();

    public static void cleanupClass() {
        ConfigurationFactory.removeConfigurationFactory((ConfigurationFactory)cf);
    }

    @BeforeClass
    public static void setupClass() {
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)cf);
        LoggerContext ctx = LoggerContext.getContext();
        ctx.reconfigure();
    }

    private void assertToByteArray(String expectedStr, PatternLayout layout, LogEvent event) {
        byte[] result = layout.toByteArray(event);
        Assert.assertEquals((Object)expectedStr, (Object)new String(result));
    }

    private void assertEncode(String expectedStr, PatternLayout layout, LogEvent event) {
        Destination destination = new Destination();
        layout.encode(event, (ByteBufferDestination)destination);
        ByteBuffer byteBuffer = destination.getByteBuffer();
        byteBuffer.flip();
        Assert.assertEquals((Object)expectedStr, (Object)new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining()));
    }

    @Test
    public void testEqualsEmptyMarker() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%logger]%equals{[%marker]}{[]}{} %msg").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMarker(MarkerManager.getMarker((String)"TestMarker")).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("[org.apache.logging.log4j.core.layout.PatternLayoutTest][TestMarker] Hello, world!", layout, (LogEvent)event1);
        this.assertEncode("[org.apache.logging.log4j.core.layout.PatternLayoutTest][TestMarker] Hello, world!", layout, (LogEvent)event1);
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("[org.apache.logging.log4j.core.layout.PatternLayoutTest] Hello, world!", layout, (LogEvent)event2);
        this.assertEncode("[org.apache.logging.log4j.core.layout.PatternLayoutTest] Hello, world!", layout, (LogEvent)event2);
    }

    @Test
    public void testHeaderFooterJavaLookup() throws Exception {
        String pattern = "%d{UNIX} MyApp%n${java:version}%n${java:runtime}%n${java:vm}%n${java:os}%n${java:hw}";
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(this.ctx.getConfiguration()).withHeader("Header: %d{UNIX} MyApp%n${java:version}%n${java:runtime}%n${java:vm}%n${java:os}%n${java:hw}").withFooter("Footer: %d{UNIX} MyApp%n${java:version}%n${java:runtime}%n${java:vm}%n${java:os}%n${java:hw}").build();
        byte[] header = layout.getHeader();
        Assert.assertNotNull((String)"No header", (Object)header);
        String headerStr = new String(header);
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains("Header: "));
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains("Java version "));
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains("(build "));
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains(" from "));
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains(" architecture: "));
        Assert.assertFalse((String)headerStr, (boolean)headerStr.contains("%d{UNIX}"));
        byte[] footer = layout.getFooter();
        Assert.assertNotNull((String)"No footer", (Object)footer);
        String footerStr = new String(footer);
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains("Footer: "));
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains("Java version "));
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains("(build "));
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains(" from "));
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains(" architecture: "));
        Assert.assertFalse((String)footerStr, (boolean)footerStr.contains("%d{UNIX}"));
    }

    @Test
    public void testHeaderFooterMainLookup() {
        MainMapLookup.setMainArguments((String[])new String[]{"value0", "value1", "value2"});
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(this.ctx.getConfiguration()).withHeader("${main:0}").withFooter("${main:2}").build();
        byte[] header = layout.getHeader();
        Assert.assertNotNull((String)"No header", (Object)header);
        String headerStr = new String(header);
        Assert.assertTrue((String)headerStr, (boolean)headerStr.contains("value0"));
        byte[] footer = layout.getFooter();
        Assert.assertNotNull((String)"No footer", (Object)footer);
        String footerStr = new String(footer);
        Assert.assertTrue((String)footerStr, (boolean)footerStr.contains("value2"));
    }

    @Test
    public void testHeaderFooterThreadContext() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{UNIX} %m").withConfiguration(this.ctx.getConfiguration()).withHeader("${ctx:header}").withFooter("${ctx:footer}").build();
        ThreadContext.put((String)"header", (String)"Hello world Header");
        ThreadContext.put((String)"footer", (String)"Hello world Footer");
        byte[] header = layout.getHeader();
        Assert.assertNotNull((String)"No header", (Object)header);
        Assert.assertTrue((String)("expected \"Hello world Header\", actual " + Strings.dquote((String)new String(header))), (boolean)new String(header).equals(new String("Hello world Header")));
    }

    private void testMdcPattern(String patternStr, String expectedStr, boolean useThreadContext) throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(patternStr).withConfiguration(this.ctx.getConfiguration()).build();
        if (useThreadContext) {
            ThreadContext.put((String)"key1", (String)"value1");
            ThreadContext.put((String)"key2", (String)"value2");
        }
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello")).build();
        this.assertToByteArray(expectedStr, layout, (LogEvent)event);
        this.assertEncode(expectedStr, layout, (LogEvent)event);
    }

    @Test
    public void testMdcPattern0() throws Exception {
        this.testMdcPattern("%m : %X", "Hello : {key1=value1, key2=value2}", true);
    }

    @Test
    public void testMdcPattern1() throws Exception {
        this.testMdcPattern("%m : %X", "Hello : {}", false);
    }

    @Test
    public void testMdcPattern2() throws Exception {
        this.testMdcPattern("%m : %X{key1}", "Hello : value1", true);
    }

    @Test
    public void testMdcPattern3() throws Exception {
        this.testMdcPattern("%m : %X{key2}", "Hello : value2", true);
    }

    @Test
    public void testMdcPattern4() throws Exception {
        this.testMdcPattern("%m : %X{key3}", "Hello : ", true);
    }

    @Test
    public void testMdcPattern5() throws Exception {
        this.testMdcPattern("%m : %X{key1}, %X{key2}, %X{key3}", "Hello : value1, value2, ", true);
    }

    @Test
    public void testPatternSelector() throws Exception {
        PatternMatch[] patterns = new PatternMatch[]{new PatternMatch("FLOW", "%d %-5p [%t]: ====== %C{1}.%M:%L %m ======%n")};
        MarkerPatternSelector selector = MarkerPatternSelector.createSelector((PatternMatch[])patterns, (String)"%d %-5p [%t]: %m%n", (boolean)true, (boolean)true, (Configuration)this.ctx.getConfiguration());
        PatternLayout layout = PatternLayout.newBuilder().withPatternSelector((PatternSelector)selector).withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.layout.PatternLayoutTest$FauxLogger").setMarker(MarkerManager.getMarker((String)"FLOW")).setLevel(Level.TRACE).setIncludeLocation(true).setMessage((Message)new SimpleMessage("entry")).build();
        String result1 = new FauxLogger().formatEvent((LogEvent)event1, (Layout<?>)layout);
        String expectPattern1 = String.format(".*====== PatternLayoutTest.testPatternSelector:\\d+ entry ======%n", new Object[0]);
        Assert.assertTrue((String)("Unexpected result: " + result1), (boolean)result1.matches(expectPattern1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        String result2 = new String(layout.toByteArray((LogEvent)event2));
        String expectSuffix2 = String.format("Hello, world 1!%n", new Object[0]);
        Assert.assertTrue((String)("Unexpected result: " + result2), (boolean)result2.endsWith(expectSuffix2));
    }

    @Test
    public void testRegex() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(regexPattern).withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("org/apache/logging/log4j/core/layout/PatternLayoutTest Hello, world!", layout, (LogEvent)event);
        this.assertEncode("org/apache/logging/log4j/core/layout/PatternLayoutTest Hello, world!", layout, (LogEvent)event);
    }

    @Test
    public void testRegexEmptyMarker() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%logger]%replace{[%marker]}{\\[\\]}{} %msg").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMarker(MarkerManager.getMarker((String)"TestMarker")).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("[org.apache.logging.log4j.core.layout.PatternLayoutTest][TestMarker] Hello, world!", layout, (LogEvent)event1);
        this.assertEncode("[org.apache.logging.log4j.core.layout.PatternLayoutTest][TestMarker] Hello, world!", layout, (LogEvent)event1);
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("[org.apache.logging.log4j.core.layout.PatternLayoutTest] Hello, world!", layout, (LogEvent)event2);
        this.assertEncode("[org.apache.logging.log4j.core.layout.PatternLayoutTest] Hello, world!", layout, (LogEvent)event2);
    }

    @Test
    public void testEqualsMarkerWithMessageSubstitution() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%logger]%equals{[%marker]}{[]}{[%msg]}").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMarker(MarkerManager.getMarker((String)"TestMarker")).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        byte[] result1 = layout.toByteArray((LogEvent)event1);
        Assert.assertEquals((Object)"[org.apache.logging.log4j.core.layout.PatternLayoutTest][TestMarker]", (Object)new String(result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        byte[] result2 = layout.toByteArray((LogEvent)event2);
        Assert.assertEquals((Object)"[org.apache.logging.log4j.core.layout.PatternLayoutTest][Hello, world!]", (Object)new String(result2));
    }

    @Test
    public void testSpecialChars() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("\\\\%level\\t%msg\\n\\t%logger\\r\\n\\f").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world!")).build();
        this.assertToByteArray("\\INFO\tHello, world!\n\torg.apache.logging.log4j.core.layout.PatternLayoutTest\r\n\f", layout, (LogEvent)event);
        this.assertEncode("\\INFO\tHello, world!\n\torg.apache.logging.log4j.core.layout.PatternLayoutTest\r\n\f", layout, (LogEvent)event);
    }

    @Test
    public void testUnixTime() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{UNIX} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        byte[] result1 = layout.toByteArray((LogEvent)event1);
        Assert.assertEquals((Object)(event1.getTimeMillis() / 1000L + " Hello, world 1!"), (Object)new String(result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 2!")).build();
        byte[] result2 = layout.toByteArray((LogEvent)event2);
        Assert.assertEquals((Object)(event2.getTimeMillis() / 1000L + " Hello, world 2!"), (Object)new String(result2));
    }

    private void testUnixTime(String pattern) throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern(pattern + " %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        byte[] result1 = layout.toByteArray((LogEvent)event1);
        Assert.assertEquals((Object)(event1.getTimeMillis() + " Hello, world 1!"), (Object)new String(result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 2!")).build();
        byte[] result2 = layout.toByteArray((LogEvent)event2);
        Assert.assertEquals((Object)(event2.getTimeMillis() + " Hello, world 2!"), (Object)new String(result2));
    }

    @Test
    public void testUnixTimeMillis() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d{UNIX_MILLIS} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        byte[] result1 = layout.toByteArray((LogEvent)event1);
        Assert.assertEquals((Object)(event1.getTimeMillis() + " Hello, world 1!"), (Object)new String(result1));
        Log4jLogEvent event2 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 2!")).build();
        byte[] result2 = layout.toByteArray((LogEvent)event2);
        Assert.assertEquals((Object)(event2.getTimeMillis() + " Hello, world 2!"), (Object)new String(result2));
    }

    @Test
    public void testUsePlatformDefaultIfNoCharset() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%m").withConfiguration(this.ctx.getConfiguration()).build();
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)layout.getCharset());
    }

    @Test
    public void testUseSpecifiedCharsetIfExists() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%m").withConfiguration(this.ctx.getConfiguration()).withCharset(StandardCharsets.UTF_8).build();
        Assert.assertEquals((Object)StandardCharsets.UTF_8, (Object)layout.getCharset());
    }

    @Test
    public void testLoggerNameTruncationByRetainingPartsFromEnd() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%c{1} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        String result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%c{2} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        result1 = layout.toSerializable((LogEvent)event1);
        String name = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf("."));
        name = name.substring(0, name.lastIndexOf("."));
        Assert.assertEquals((Object)(this.getClass().getName().substring(name.length() + 1) + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%c{20} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName() + " Hello, world 1!"), (Object)new String(result1));
    }

    @Test
    public void testCallersFqcnTruncationByRetainingPartsFromEnd() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%C{1} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByRetainingPartsFromEnd", this.getClass().getCanonicalName() + ".java", 440)).build();
        String result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%C{2} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByRetainingPartsFromEnd", this.getClass().getCanonicalName() + ".java", 440)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        String name = this.getClass().getName().substring(0, this.getClass().getName().lastIndexOf("."));
        name = name.substring(0, name.lastIndexOf("."));
        Assert.assertEquals((Object)(this.getClass().getName().substring(name.length() + 1) + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%C{20} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByRetainingPartsFromEnd", this.getClass().getCanonicalName() + ".java", 440)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName() + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%class{1} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByRetainingPartsFromEnd", this.getClass().getCanonicalName() + ".java", 440)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1) + " Hello, world 1!"), (Object)new String(result1));
    }

    @Test
    public void testLoggerNameTruncationByDroppingPartsFromFront() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%c{-1} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        String result1 = layout.toSerializable((LogEvent)event1);
        String name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%c{-3} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        result1 = layout.toSerializable((LogEvent)event1);
        name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%logger{-3} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        result1 = layout.toSerializable((LogEvent)event1);
        name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%c{-20} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).build();
        result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName() + " Hello, world 1!"), (Object)new String(result1));
    }

    @Test
    public void testCallersFqcnTruncationByDroppingPartsFromFront() throws Exception {
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%C{-1} %m").withConfiguration(this.ctx.getConfiguration()).build();
        Log4jLogEvent event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByDroppingPartsFromFront", this.getClass().getCanonicalName() + ".java", 546)).build();
        String result1 = layout.toSerializable((LogEvent)event1);
        String name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%C{-3} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByDroppingPartsFromFront", this.getClass().getCanonicalName() + ".java", 546)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%class{-3} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByDroppingPartsFromFront", this.getClass().getCanonicalName() + ".java", 546)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        name = this.getClass().getName().substring(this.getClass().getName().indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        name = name.substring(name.indexOf(".") + 1);
        Assert.assertEquals((Object)(name + " Hello, world 1!"), (Object)new String(result1));
        layout = PatternLayout.newBuilder().withPattern("%C{-20} %m").withConfiguration(this.ctx.getConfiguration()).build();
        event1 = Log4jLogEvent.newBuilder().setLoggerName(this.getClass().getName()).setLoggerFqcn("org.apache.logging.log4j.core.Logger").setLevel(Level.INFO).setMessage((Message)new SimpleMessage("Hello, world 1!")).setSource(new StackTraceElement(this.getClass().getName(), "testCallersFqcnTruncationByDroppingPartsFromFront", this.getClass().getCanonicalName() + ".java", 546)).build();
        result1 = layout.toSerializable((LogEvent)event1);
        Assert.assertEquals((Object)(this.getClass().getName() + " Hello, world 1!"), (Object)new String(result1));
    }

    private static class Destination
    implements ByteBufferDestination {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[2048]);

        private Destination() {
        }

        public ByteBuffer getByteBuffer() {
            return this.byteBuffer;
        }

        public ByteBuffer drain(ByteBuffer buf) {
            throw new IllegalStateException("Unexpected message larger than 2048 bytes");
        }

        public void writeBytes(ByteBuffer data) {
            this.byteBuffer.put(data);
        }

        public void writeBytes(byte[] data, int offset, int length) {
            this.byteBuffer.put(data, offset, length);
        }
    }

    public class FauxLogger {
        public String formatEvent(LogEvent event, Layout<?> layout) {
            return new String(layout.toByteArray(event));
        }
    }
}

