/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;
import org.junit.Assert;
import org.junit.Test;

public class JdkMapAdapterStringMapTest {
    static TriConsumer<String, String, State> COUNTER = new TriConsumer<String, String, State>(){

        public void accept(String key, String value, State state) {
            ++state.count;
            Assert.assertTrue((String)("count should not exceed size but was " + state.count), (state.count <= state.data.size() ? 1 : 0) != 0);
        }
    };

    @Test(expected=NullPointerException.class)
    public void testConstructorDisallowsNull() throws Exception {
        new JdkMapAdapterStringMap(null);
    }

    @Test
    public void testToString() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("a2", (Object)"bvalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("C", (Object)"Cvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"{3=3value, B=Bvalue, C=Cvalue, a=avalue, a2=bvalue}", (Object)original.toString());
    }

    @Test
    public void testSerialization() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        byte[] binary = this.serialize(original);
        JdkMapAdapterStringMap copy = this.deserialize(binary);
        Assert.assertEquals((Object)original, (Object)copy);
    }

    private byte[] serialize(JdkMapAdapterStringMap data) throws IOException {
        ByteArrayOutputStream arr = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(arr);
        out.writeObject(data);
        return arr.toByteArray();
    }

    private JdkMapAdapterStringMap deserialize(byte[] binary) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inArr = new ByteArrayInputStream(binary);
        ObjectInputStream in = new ObjectInputStream(inArr);
        JdkMapAdapterStringMap result = (JdkMapAdapterStringMap)in.readObject();
        return result;
    }

    @Test
    public void testPutAll() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putAll((ReadOnlyStringMap)original);
        Assert.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testPutAll_overwritesSameKeys2() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testPutAll_nullKeyInLargeOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullORIG", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInSmallAdditional() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInLargeAdditional() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_LargeOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        original.putValue("d", (Object)"dORIG");
        original.putValue("e", (Object)"eORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)7L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cORIG", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"dORIG", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"eORIG", (Object)original.getValue("e"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_nullKeyInBoth_SmallOriginal() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullORIG");
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue(null, (Object)"nullNEW");
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("3", (Object)"33");
        other.putValue("a", (Object)"aa");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"33", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"nullNEW", (Object)original.getValue(null));
    }

    @Test
    public void testPutAll_overwritesSameKeys1() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aORIG");
        original.putValue("b", (Object)"bORIG");
        original.putValue("c", (Object)"cORIG");
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"11");
        other.putValue("2", (Object)"22");
        other.putValue("a", (Object)"aa");
        other.putValue("c", (Object)"cc");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)5L, (long)original.size());
        Assert.assertEquals((Object)"aa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bORIG", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"cc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"11", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"22", (Object)original.getValue("2"));
    }

    @Test
    public void testEquals() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)original);
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("a", (Object)"avalue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("B", (Object)"Bvalue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"otherValue");
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", null);
        Assert.assertNotEquals((Object)original, (Object)other);
        other.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)original, (Object)other);
    }

    @Test
    public void testToMap() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        Assert.assertEquals(expected, (Object)original.toMap());
        try {
            original.toMap().put("abc", "xyz");
        }
        catch (UnsupportedOperationException ex) {
            Assert.fail((String)("Expected map to be mutable, but " + ex));
        }
    }

    @Test
    public void testPutAll_KeepsExistingValues() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assert.assertEquals((String)"size", (long)3L, (long)original.size());
        original.putAll((ReadOnlyStringMap)new JdkMapAdapterStringMap());
        Assert.assertEquals((String)"size after put empty", (long)3L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)6L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"333", (Object)original.getValue("3"));
    }

    @Test
    public void testPutAll_sizePowerOfTwo() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assert.assertEquals((String)"size", (long)4L, (long)original.size());
        original.putAll((ReadOnlyStringMap)new JdkMapAdapterStringMap());
        Assert.assertEquals((String)"size after put empty", (long)4L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        other.putValue("1", (Object)"111");
        other.putValue("2", (Object)"222");
        other.putValue("3", (Object)"333");
        other.putValue("4", (Object)"444");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)8L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        Assert.assertEquals((Object)"111", (Object)original.getValue("1"));
        Assert.assertEquals((Object)"222", (Object)original.getValue("2"));
        Assert.assertEquals((Object)"333", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"444", (Object)original.getValue("4"));
    }

    @Test
    public void testPutAll_largeAddition() {
        int i;
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue(null, (Object)"nullVal");
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        original.putValue("d", (Object)"ddd");
        Assert.assertEquals((String)"size", (long)5L, (long)original.size());
        JdkMapAdapterStringMap other = new JdkMapAdapterStringMap();
        for (i = 0; i < 500; ++i) {
            other.putValue(String.valueOf(i), (Object)String.valueOf(i));
        }
        other.putValue(null, (Object)"otherVal");
        original.putAll((ReadOnlyStringMap)other);
        Assert.assertEquals((String)"size after put other", (long)505L, (long)original.size());
        Assert.assertEquals((Object)"otherVal", (Object)original.getValue(null));
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
        Assert.assertEquals((Object)"ddd", (Object)original.getValue("d"));
        for (i = 0; i < 500; ++i) {
            Assert.assertEquals((Object)String.valueOf(i), (Object)original.getValue(String.valueOf(i)));
        }
    }

    @Test
    public void testPutAllSelfDoesNotModify() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"bbb");
        original.putValue("c", (Object)"ccc");
        Assert.assertEquals((String)"size", (long)3L, (long)original.size());
        original.putAll((ReadOnlyStringMap)original);
        Assert.assertEquals((String)"size after put empty", (long)3L, (long)original.size());
        Assert.assertEquals((Object)"aaa", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"bbb", (Object)original.getValue("b"));
        Assert.assertEquals((Object)"ccc", (Object)original.getValue("c"));
    }

    @Test
    public void testNoConcurrentModificationBiConsumerPut() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.putValue("c" + s, (Object)"other");
            }
        });
    }

    @Test
    public void testNoConcurrentModificationBiConsumerPutValue() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.putValue("c" + s, (Object)"other");
            }
        });
    }

    @Test
    public void testNoConcurrentModificationBiConsumerRemove() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.remove("a");
            }
        });
    }

    @Test
    public void testNoConcurrentModificationBiConsumerClear() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((BiConsumer)new BiConsumer<String, Object>(){

            public void accept(String s, Object o) {
                original.clear();
            }
        });
    }

    @Test
    public void testNoConcurrentModificationTriConsumerPut() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.putValue("c", (Object)"other");
            }
        }, null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerPutValue() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.putValue("e", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.putValue("c" + s, (Object)"other");
            }
        }, null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerRemove() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.remove("a");
            }
        }, null);
    }

    @Test
    public void testNoConcurrentModificationTriConsumerClear() {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.putValue("b", (Object)"aaa");
        original.putValue("c", (Object)"aaa");
        original.putValue("d", (Object)"aaa");
        original.forEach((TriConsumer)new TriConsumer<String, Object, Object>(){

            public void accept(String s, Object o, Object o2) {
                original.clear();
            }
        }, null);
    }

    @Test
    public void testInitiallyNotFrozen() {
        Assert.assertFalse((boolean)new JdkMapAdapterStringMap().isFrozen());
    }

    @Test
    public void testIsFrozenAfterCallingFreeze() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assert.assertFalse((String)"before freeze", (boolean)original.isFrozen());
        original.freeze();
        Assert.assertTrue((String)"after freeze", (boolean)original.isFrozen());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsPutValue() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        original.putValue("a", (Object)"aaa");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        original.remove("b");
    }

    @Test
    public void testFreezeAllowsRemoveOfNonExistingKey() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("b", (Object)"bbb");
        original.freeze();
        original.remove("a");
    }

    @Test
    public void testFreezeAllowsRemoveIfEmpty() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        original.remove("a");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testFreezeProhibitsClear() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"aaa");
        original.freeze();
        original.clear();
    }

    @Test
    public void testFreezeAllowsClearIfEmpty() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.freeze();
        original.clear();
    }

    @Test
    public void testNullKeysAllowed() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((long)5L, (long)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"nullvalue", (Object)original.getValue(null));
        original.putValue(null, (Object)"otherNullvalue");
        Assert.assertEquals((Object)"otherNullvalue", (Object)original.getValue(null));
        Assert.assertEquals((long)6L, (long)original.size());
        original.putValue(null, (Object)"nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"nullvalue", (Object)original.getValue(null));
        original.putValue(null, (Object)"abc");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((Object)"abc", (Object)original.getValue(null));
    }

    @Test
    public void testNullKeysCopiedToAsMap() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        Assert.assertEquals((long)5L, (long)original.size());
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("a", "avalue");
        expected.put("B", "Bvalue");
        expected.put("3", "3value");
        expected.put("c", "cvalue");
        expected.put("d", "dvalue");
        Assert.assertEquals((String)"initial", expected, (Object)original.toMap());
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key", expected, (Object)original.toMap());
        original.putValue(null, (Object)"otherNullvalue");
        expected.put(null, "otherNullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value2", expected, (Object)original.toMap());
        original.putValue(null, (Object)"nullvalue");
        expected.put(null, "nullvalue");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value1 again", expected, (Object)original.toMap());
        original.putValue(null, (Object)"abc");
        expected.put(null, "abc");
        Assert.assertEquals((long)6L, (long)original.size());
        Assert.assertEquals((String)"with null key value3", expected, (Object)original.toMap());
    }

    @Test
    public void testRemove() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.remove("a");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertNull((String)"no a val", (Object)original.getValue("a"));
        original.remove("B");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertNull((String)"no B val", (Object)original.getValue("B"));
    }

    @Test
    public void testRemoveWhenFull() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("b", (Object)"bvalue");
        original.putValue("c", (Object)"cvalue");
        original.putValue("d", (Object)"dvalue");
        original.remove("d");
    }

    @Test
    public void testNullValuesArePreserved() {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        original.putValue("a", null);
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertNull((String)"no a val", (Object)original.getValue("a"));
        original.putValue("B", null);
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertNull((String)"no B val", (Object)original.getValue("B"));
    }

    @Test
    public void testGet() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        original.putValue("0", (Object)"0value");
        Assert.assertEquals((Object)"0value", (Object)original.getValue("0"));
        Assert.assertEquals((Object)"3value", (Object)original.getValue("3"));
        Assert.assertEquals((Object)"Bvalue", (Object)original.getValue("B"));
        Assert.assertEquals((Object)"avalue", (Object)original.getValue("a"));
    }

    @Test
    public void testClear() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((long)3L, (long)original.size());
        original.clear();
        Assert.assertEquals((long)0L, (long)original.size());
    }

    @Test
    public void testContainsKey() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assert.assertFalse((String)"a", (boolean)original.containsKey("a"));
        Assert.assertFalse((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("a", (Object)"avalue");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertFalse((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("B", (Object)"Bvalue");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertFalse((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("3", (Object)"3value");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertTrue((String)"3", (boolean)original.containsKey("3"));
        Assert.assertFalse((String)"A", (boolean)original.containsKey("A"));
        original.putValue("A", (Object)"AAA");
        Assert.assertTrue((String)"a", (boolean)original.containsKey("a"));
        Assert.assertTrue((String)"B", (boolean)original.containsKey("B"));
        Assert.assertTrue((String)"3", (boolean)original.containsKey("3"));
        Assert.assertTrue((String)"A", (boolean)original.containsKey("A"));
    }

    @Test
    public void testSizeAndIsEmpty() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertTrue((String)"initial", (boolean)original.isEmpty());
        original.putValue("a", (Object)"avalue");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.putValue("B", (Object)"Bvalue");
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.putValue("3", (Object)"3value");
        Assert.assertEquals((long)3L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("B");
        Assert.assertEquals((long)2L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("3");
        Assert.assertEquals((long)1L, (long)original.size());
        Assert.assertFalse((String)("size=" + original.size()), (boolean)original.isEmpty());
        original.remove("a");
        Assert.assertEquals((long)0L, (long)original.size());
        Assert.assertTrue((String)("size=" + original.size()), (boolean)original.isEmpty());
    }

    @Test
    public void testForEachBiConsumer() throws Exception {
        final JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        original.forEach((BiConsumer)new BiConsumer<String, String>(){
            int count = 0;

            public void accept(String key, String value) {
                ++this.count;
                Assert.assertTrue((String)("count should not exceed size but was " + this.count), (this.count <= original.size() ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testForEachTriConsumer() throws Exception {
        JdkMapAdapterStringMap original = new JdkMapAdapterStringMap();
        original.putValue("a", (Object)"avalue");
        original.putValue("B", (Object)"Bvalue");
        original.putValue("3", (Object)"3value");
        State state = new State();
        state.data = original;
        original.forEach(COUNTER, (Object)state);
        Assert.assertEquals((long)state.count, (long)original.size());
    }

    static class State {
        JdkMapAdapterStringMap data;
        int count;

        State() {
        }
    }
}

