/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractScriptFilterTest {
    public abstract LoggerContextRule getContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroovyFilter() throws Exception {
        Logger logger = LogManager.getLogger((String)"TestGroovyFilter");
        logger.traceEntry();
        logger.info("This should not be logged");
        ThreadContext.put((String)"UserId", (String)"JohnDoe");
        logger.info("This should be logged");
        ThreadContext.clearMap();
        ListAppender app = this.getContext().getListAppender("List");
        try {
            List<String> messages = app.getMessages();
            Assert.assertNotNull((String)"No Messages", messages);
            Assert.assertTrue((String)("Incorrect number of messages. Expected 2, Actual " + messages.size()), (messages.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            app.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJavascriptFilter() throws Exception {
        Logger logger = LogManager.getLogger((String)"TestJavaScriptFilter");
        logger.traceEntry();
        logger.info("This should not be logged");
        ThreadContext.put((String)"UserId", (String)"JohnDoe");
        logger.info("This should be logged");
        ThreadContext.clearMap();
        ListAppender app = this.getContext().getListAppender("List");
        List<String> messages = app.getMessages();
        try {
            Assert.assertNotNull((String)"No Messages", messages);
            Assert.assertTrue((String)("Incorrect number of messages. Expected 2, Actual " + messages.size()), (messages.size() == 2 ? 1 : 0) != 0);
        }
        finally {
            app.clear();
        }
    }
}

