/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.FailoverAppender;
import org.apache.logging.log4j.core.appender.FailoversPlugin;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginBuilder;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidatingPluginWithFailoverTest {
    private PluginType<FailoverAppender> plugin;
    private Node node;

    @Before
    public void setUp() throws Exception {
        PluginManager manager = new PluginManager("Core");
        manager.collectPlugins();
        this.plugin = manager.getPluginType("failover");
        Assert.assertNotNull((String)"Rebuild this module to make sure annotation processing kicks in.", this.plugin);
        AppenderRef appenderRef = AppenderRef.createAppenderRef((String)"List", (Level)Level.ALL, null);
        this.node = new Node(null, "failover", this.plugin);
        Node failoversNode = new Node(this.node, "Failovers", manager.getPluginType("Failovers"));
        Node appenderRefNode = new Node(failoversNode, "appenderRef", manager.getPluginType("appenderRef"));
        appenderRefNode.getAttributes().put("ref", "file");
        appenderRefNode.setObject((Object)appenderRef);
        failoversNode.getChildren().add(appenderRefNode);
        failoversNode.setObject((Object)FailoversPlugin.createFailovers((AppenderRef[])new AppenderRef[]{appenderRef}));
        this.node.getAttributes().put("primary", "CONSOLE");
        this.node.getAttributes().put("name", "Failover");
        this.node.getChildren().add(failoversNode);
    }

    @Test
    public void testDoesNotLog_NoParameterThatMatchesElement_message() {
        StoringStatusListener listener = new StoringStatusListener();
        PluginBuilder builder = new PluginBuilder(this.plugin).withConfiguration((Configuration)new NullConfiguration()).withConfigurationNode(this.node);
        StatusLogger.getLogger().registerListener((StatusListener)listener);
        FailoverAppender failoverAppender = (FailoverAppender)builder.build();
        Assert.assertThat((Object)listener.logs, (Matcher)Matchers.emptyCollectionOf(StatusData.class));
        Assert.assertNotNull((Object)failoverAppender);
        Assert.assertEquals((Object)"Failover", (Object)failoverAppender.getName());
    }

    private static class StoringStatusListener
    implements StatusListener {
        private final List<StatusData> logs = new ArrayList<StatusData>();

        private StoringStatusListener() {
        }

        public void log(StatusData data) {
            this.logs.add(data);
        }

        public Level getStatusLevel() {
            return Level.WARN;
        }

        public void close() {
        }
    }
}

