/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.hamcrest.MapMatchers;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MissingRootLoggerTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("missingRootLogger.xml");

    @Test
    public void testMissingRootLogger() throws Exception {
        LoggerContext ctx = this.context.getLoggerContext();
        Logger logger = ctx.getLogger("sample.Logger1");
        Assert.assertTrue((String)"Logger should have the INFO level enabled", (boolean)logger.isInfoEnabled());
        Assert.assertFalse((String)"Logger should have the DEBUG level disabled", (boolean)logger.isDebugEnabled());
        Configuration config = ctx.getConfiguration();
        Assert.assertNotNull((String)"Config not null", (Object)config);
        Map map = config.getAppenders();
        Assert.assertNotNull((String)"Appenders not null", (Object)map);
        Assert.assertThat((String)"There should only be two appenders", (Object)map, MapMatchers.hasSize(2));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"List"));
        Assert.assertThat((Object)map, (Matcher)Matchers.hasKey((Object)"DefaultConsole-2"));
        Map loggerMap = config.getLoggers();
        Assert.assertNotNull((String)"loggerMap not null", (Object)loggerMap);
        Assert.assertThat((String)"There should only be one configured logger", (Object)loggerMap, MapMatchers.hasSize(1));
        Assert.assertThat((String)"contains key=sample", (Object)loggerMap, (Matcher)Matchers.hasKey((Object)"sample"));
        LoggerConfig sample = (LoggerConfig)loggerMap.get("sample");
        Map sampleAppenders = sample.getAppenders();
        Assert.assertThat((String)"The sample logger should only have one appender", (Object)sampleAppenders, MapMatchers.hasSize(1));
        Assert.assertThat((String)"The sample appender should be a ListAppender", (Object)sampleAppenders, (Matcher)Matchers.hasKey((Object)"List"));
        Assert.assertThat((Object)config, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(AbstractConfiguration.class)));
        AbstractConfiguration baseConfig = (AbstractConfiguration)config;
        LoggerConfig root = baseConfig.getRootLogger();
        Map rootAppenders = root.getAppenders();
        Assert.assertThat((String)"The root logger should only have one appender", (Object)rootAppenders, MapMatchers.hasSize(1));
        Assert.assertThat((String)"The root appender should be a ConsoleAppender", (Object)rootAppenders, (Matcher)Matchers.hasKey((Object)"DefaultConsole-2"));
        Assert.assertEquals((Object)Level.ERROR, (Object)root.getLevel());
    }
}

