/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.ThreadContextMapFilter;
import org.apache.logging.log4j.junit.CleanFiles;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConfigurationTest {
    private static final String LOGGER_NAME = "org.apache.logging.log4j.test1.Test";
    private static final String FILE_LOGGER_NAME = "org.apache.logging.log4j.test2.Test";
    private static final String APPENDER_NAME = "STDOUT";
    private final String logFileName;
    @Rule
    public TestRule rules;
    private final LoggerContextRule init;
    private LoggerContext ctx;
    private final SecureRandom random = new SecureRandom();

    public ConfigurationTest(String configFileName, String logFileName) {
        this.logFileName = logFileName;
        this.init = new LoggerContextRule(configFileName);
        this.rules = RuleChain.outerRule((TestRule)new CleanFiles(logFileName)).around((TestRule)this.init);
    }

    @Parameterized.Parameters(name="config={0}, log={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"classpath:log4j-test1.xml", "target/test-xml.log"}, {"classpath:log4j-test1.json", "target/test-json.log"}, {"classpath:log4j-test1.yaml", "target/test-yaml.log"}, {"classpath:log4j-test1.properties", "target/test-properties.log"});
    }

    @Before
    public void setUp() throws Exception {
        this.ctx = this.init.getLoggerContext();
    }

    @Test
    public void testConfiguredAppenders() throws Exception {
        Configuration configuration = this.ctx.getConfiguration();
        Map appenders = configuration.getAppenders();
        Assert.assertThat((Object)appenders, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)appenders.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
    }

    @Test
    public void testConfigurationLoggerContext() throws Exception {
        Configuration configuration = this.ctx.getConfiguration();
        Assert.assertThat((Object)configuration.getLoggerContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetLoggerConfigEmpty() throws Exception {
        Configuration config = this.ctx.getConfiguration();
        Assert.assertEquals((Object)config.getRootLogger(), (Object)config.getLoggerConfig(""));
    }

    @Test(expected=NullPointerException.class)
    public void testGetLoggerConfigNull() throws Exception {
        Configuration config = this.ctx.getConfiguration();
        Assert.assertEquals((Object)config.getRootLogger(), (Object)config.getLoggerConfig(null));
    }

    @Test
    public void testLogger() throws Exception {
        Logger logger = this.ctx.getLogger(LOGGER_NAME);
        Assert.assertThat((Object)logger, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Logger.class)));
        Logger l = logger;
        Assert.assertThat((Object)l.getLevel(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)Level.DEBUG)));
        Assert.assertThat((Object)l.filterCount(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Iterator iterator = l.getFilters();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Filter filter = (Filter)iterator.next();
        Assert.assertThat((Object)filter, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ThreadContextMapFilter.class)));
        Map appenders = l.getAppenders();
        Assert.assertThat((Object)appenders, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)appenders.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Appender appender = (Appender)appenders.get(APPENDER_NAME);
        Assert.assertThat((Object)appender, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)appender.getName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)APPENDER_NAME)));
    }

    @Test
    public void testLogToFile() throws Exception {
        Logger logger = this.ctx.getLogger(FILE_LOGGER_NAME);
        long random = this.random.nextLong();
        logger.debug("This is test message number {}", (Object)random);
        int count = 0;
        String line = "";
        try (BufferedReader in = new BufferedReader(new FileReader(this.logFileName));){
            while (in.ready()) {
                ++count;
                line = in.readLine();
            }
        }
        Assert.assertThat((Object)count, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)1)));
        Assert.assertThat((Object)line, (Matcher)CoreMatchers.endsWith((String)Long.toString(random)));
    }
}

