/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.async.BlockingAppender;
import org.apache.logging.log4j.core.async.QueueFullAbstractTest;
import org.apache.logging.log4j.junit.LoggerContextRule;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@Ignore
@RunWith(value=BlockJUnit4ClassRunner.class)
@Category(value={AsyncLoggers.class})
public class QueueFullAsyncLoggerLoggingFromToStringTest2
extends QueueFullAbstractTest {
    @Rule
    public LoggerContextRule context = new LoggerContextRule("log4j2-queueFull.xml", AsyncLoggerContextSelector.class);

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("log4j.format.msg.async", "true");
        System.setProperty("AsyncLogger.RingBufferSize", "128");
        System.setProperty("log4j.configurationFile", "log4j2-queueFull.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Before
    public void before() throws Exception {
        this.blockingAppender = this.context.getRequiredAppender("Blocking", BlockingAppender.class);
        TRACE = true;
    }

    @Ignore
    @Test(timeout=5000L)
    public void testLoggingFromToStringCausesOutOfOrderMessages() throws InterruptedException {
        Logger logger = LogManager.getLogger(this.getClass());
        this.blockingAppender.countDownLatch = new CountDownLatch(1);
        this.unlocker = new QueueFullAbstractTest.Unlocker(new CountDownLatch(129));
        this.unlocker.start();
        for (int i = 0; i < 1; ++i) {
            QueueFullAsyncLoggerLoggingFromToStringTest2.TRACE("Test logging message " + i + ". Remaining capacity=" + QueueFullAsyncLoggerLoggingFromToStringTest2.asyncRemainingCapacity(logger));
            QueueFullAsyncLoggerLoggingFromToStringTest2.TRACE("Test decrementing unlocker countdown latch. Count=" + this.unlocker.countDownLatch.getCount());
            this.unlocker.countDownLatch.countDown();
            QueueFullAbstractTest.DomainObject obj = new QueueFullAbstractTest.DomainObject(129);
            logger.info((Message)new ParameterizedMessage("logging naughty object #{} {}", (Object)i, (Object)obj));
        }
        QueueFullAsyncLoggerLoggingFromToStringTest2.TRACE("Before stop() blockingAppender.logEvents.count=" + this.blockingAppender.logEvents.size());
        CoreLoggerContexts.stopLoggerContext(false);
        while (this.blockingAppender.logEvents.size() < 129) {
            Thread.yield();
        }
        QueueFullAsyncLoggerLoggingFromToStringTest2.TRACE("After  stop() blockingAppender.logEvents.count=" + this.blockingAppender.logEvents.size());
        Stack actual = QueueFullAsyncLoggerLoggingFromToStringTest2.transform(this.blockingAppender.logEvents);
        Assert.assertEquals((String)"Jumped the queue: test(2)+domain1(65)+domain2(61)=128: queue full", (Object)"Logging in toString() #127 (Log4j2 logged this message out of order to prevent deadlock caused by domain objects logging from their toString method when the async queue is full - LOG4J2-2031)", actual.pop());
        Assert.assertEquals((Object)"Logging in toString() #128 (Log4j2 logged this message out of order to prevent deadlock caused by domain objects logging from their toString method when the async queue is full - LOG4J2-2031)", actual.pop());
        Assert.assertEquals((Object)"logging naughty object #0 Who's bad?!", actual.pop());
        for (int i = 0; i < 127; ++i) {
            Assert.assertEquals((String)"First batch", (Object)("Logging in toString() #" + i), actual.pop());
        }
        Assert.assertTrue((boolean)actual.isEmpty());
    }
}

