/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.categories.AsyncLoggers;
import org.apache.logging.log4j.core.CoreLoggerContexts;
import org.apache.logging.log4j.core.async.AsyncLogger;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={AsyncLoggers.class})
public class AsyncLoggerTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("Log4jContextSelector", AsyncLoggerContextSelector.class.getName());
        System.setProperty("log4j.configurationFile", "AsyncLoggerTest.xml");
    }

    @AfterClass
    public static void afterClass() {
        System.setProperty("Log4jContextSelector", "");
    }

    @Test
    public void testAsyncLogWritesToLog() throws Exception {
        File file = new File("target", "AsyncLoggerTest.log");
        file.delete();
        AsyncLogger log = (AsyncLogger)LogManager.getLogger((String)"com.foo.Bar");
        Assert.assertTrue((boolean)(log.getNanoClock() instanceof DummyNanoClock));
        String msg = "Async logger msg";
        log.info("Async logger msg", (Throwable)new InternalError("this is not a real error"));
        CoreLoggerContexts.stopLoggerContext(false, file);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line1 = reader.readLine();
        reader.close();
        file.delete();
        Assert.assertNotNull((String)"line1", (Object)line1);
        Assert.assertTrue((String)"line1 correct", (boolean)line1.contains("Async logger msg"));
        String location = "testAsyncLogWritesToLog";
        Assert.assertTrue((String)"no location", (!line1.contains("testAsyncLogWritesToLog") ? 1 : 0) != 0);
    }
}

