/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.core.appender.rolling.action.PathSortByModificationTime;
import org.apache.logging.log4j.core.appender.rolling.action.PathSorter;
import org.apache.logging.log4j.core.appender.rolling.action.PathWithAttributes;
import org.apache.logging.log4j.core.appender.rolling.action.SortingVisitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SortingVisitorTest {
    private Path base;
    private Path aaa;
    private Path bbb;
    private Path ccc;

    @Before
    public void setUp() throws Exception {
        this.base = Files.createTempDirectory("tempDir", new FileAttribute[0]);
        this.aaa = Files.createTempFile(this.base, "aaa", null, new FileAttribute[0]);
        this.bbb = Files.createTempFile(this.base, "bbb", null, new FileAttribute[0]);
        this.ccc = Files.createTempFile(this.base, "ccc", null, new FileAttribute[0]);
        long now = System.currentTimeMillis();
        Files.setLastModifiedTime(this.aaa, FileTime.fromMillis(now));
        Files.setLastModifiedTime(this.bbb, FileTime.fromMillis(now + 1000L));
        Files.setLastModifiedTime(this.ccc, FileTime.fromMillis(now + 2000L));
    }

    @After
    public void tearDown() throws Exception {
        Files.deleteIfExists(this.ccc);
        Files.deleteIfExists(this.bbb);
        Files.deleteIfExists(this.aaa);
        Files.deleteIfExists(this.base);
    }

    @Test
    public void testRecentFirst() throws Exception {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(true));
        Set<FileVisitOption> options = Collections.emptySet();
        Files.walkFileTree(this.base, options, 1, (FileVisitor<? super Path>)visitor);
        List found = visitor.getSortedPaths();
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((String)"file count", (long)3L, (long)found.size());
        Assert.assertEquals((String)("1st: most recent; sorted=" + found), (Object)this.ccc, (Object)((PathWithAttributes)found.get(0)).getPath());
        Assert.assertEquals((String)("2nd; sorted=" + found), (Object)this.bbb, (Object)((PathWithAttributes)found.get(1)).getPath());
        Assert.assertEquals((String)("3rd: oldest; sorted=" + found), (Object)this.aaa, (Object)((PathWithAttributes)found.get(2)).getPath());
    }

    @Test
    public void testRecentLast() throws Exception {
        SortingVisitor visitor = new SortingVisitor((PathSorter)new PathSortByModificationTime(false));
        Set<FileVisitOption> options = Collections.emptySet();
        Files.walkFileTree(this.base, options, 1, (FileVisitor<? super Path>)visitor);
        List found = visitor.getSortedPaths();
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((String)"file count", (long)3L, (long)found.size());
        Assert.assertEquals((String)("1st: oldest first; sorted=" + found), (Object)this.aaa, (Object)((PathWithAttributes)found.get(0)).getPath());
        Assert.assertEquals((String)("2nd; sorted=" + found), (Object)this.bbb, (Object)((PathWithAttributes)found.get(1)).getPath());
        Assert.assertEquals((String)("3rd: most recent sorted; list=" + found), (Object)this.ccc, (Object)((PathWithAttributes)found.get(2)).getPath());
    }
}

