/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action;

import org.apache.logging.log4j.core.appender.rolling.action.CountingCondition;
import org.apache.logging.log4j.core.appender.rolling.action.IfAccumulatedFileCount;
import org.apache.logging.log4j.core.appender.rolling.action.PathCondition;
import org.junit.Assert;
import org.junit.Test;

public class IfAccumulatedFileCountTest {
    @Test
    public void testGetThresholdCount() {
        Assert.assertEquals((long)123L, (long)IfAccumulatedFileCount.createFileCountCondition((int)123, (PathCondition[])new PathCondition[0]).getThresholdCount());
        Assert.assertEquals((long)456L, (long)IfAccumulatedFileCount.createFileCountCondition((int)456, (PathCondition[])new PathCondition[0]).getThresholdCount());
    }

    @Test
    public void testAccept() {
        int[] counts;
        for (int count : counts = new int[]{3, 5, 9}) {
            IfAccumulatedFileCount condition = IfAccumulatedFileCount.createFileCountCondition((int)count, (PathCondition[])new PathCondition[0]);
            for (int i = 0; i < count; ++i) {
                Assert.assertFalse((boolean)condition.accept(null, null, null));
            }
            Assert.assertTrue((boolean)condition.accept(null, null, null));
            Assert.assertTrue((boolean)condition.accept(null, null, null));
        }
    }

    @Test
    public void testAcceptCallsNestedConditionsOnlyIfPathAccepted() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileCount condition = IfAccumulatedFileCount.createFileCountCondition((int)3, (PathCondition[])new PathCondition[]{counter});
        for (int i = 1; i < 10; ++i) {
            if (i <= 3) {
                Assert.assertFalse((String)("i=" + i), (boolean)condition.accept(null, null, null));
                Assert.assertEquals((long)0L, (long)counter.getAcceptCount());
                continue;
            }
            Assert.assertTrue((boolean)condition.accept(null, null, null));
            Assert.assertEquals((long)(i - 3), (long)counter.getAcceptCount());
        }
    }

    @Test
    public void testBeforeTreeWalk() {
        CountingCondition counter = new CountingCondition(true);
        IfAccumulatedFileCount filter = IfAccumulatedFileCount.createFileCountCondition((int)30, (PathCondition[])new PathCondition[]{counter, counter, counter});
        filter.beforeFileTreeWalk();
        Assert.assertEquals((long)3L, (long)counter.getBeforeFileTreeWalkCount());
    }
}

